/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.PascalCodeStatement;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class PascalProcedure {
    byte[] buffer;
    int procOffset;
    int offset;
    int slot;
    boolean valid;
    int procedureNo;
    int procLevel;
    int codeStart;
    int codeEnd;
    int parmSize;
    int dataSize;
    List<PascalCodeStatement> statements = new ArrayList<PascalCodeStatement>();
    AssemblerProgram assembler;
    int jumpTable = -8;

    public PascalProcedure(byte[] buffer, int slot) {
        this.buffer = buffer;
        this.slot = slot;
        int p = buffer.length - 2 - slot * 2;
        this.offset = Utility.getShort(buffer, p);
        this.procOffset = p - this.offset;
        boolean bl = this.valid = this.procOffset > 0;
        if (this.valid) {
            this.procedureNo = buffer[this.procOffset] & 0xFF;
            this.procLevel = buffer[this.procOffset + 1] & 0xFF;
            this.codeStart = Utility.getShort(buffer, this.procOffset - 2);
            this.codeEnd = Utility.getShort(buffer, this.procOffset - 4);
            this.parmSize = Utility.getShort(buffer, this.procOffset - 6);
            this.dataSize = Utility.getShort(buffer, this.procOffset - 8);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void decode() {
        if (this.statements.size() > 0 || this.assembler != null) {
            return;
        }
        ptr = this.procOffset - this.codeStart - 2;
        max = this.procOffset + this.jumpTable;
        if (this.codeEnd != 0) ** GOTO lbl26
        len = this.codeStart + this.jumpTable + 2;
        if (len > 0) {
            asmBuf = new byte[len];
            System.arraycopy(this.buffer, ptr, asmBuf, 0, len);
            this.assembler = new AssemblerProgram("Proc", asmBuf, ptr);
        }
        return;
lbl-1000:
        // 1 sources

        {
            if (ptr >= this.buffer.length || ptr < 0) {
                System.out.printf("Ptr outside buffer: %d %d%n", new Object[]{ptr, this.buffer.length});
                break;
            }
            cs = new PascalCodeStatement(this.buffer, ptr, this.procOffset);
            if (cs.length <= 0) {
                System.out.println("error - length <= 0 : " + cs);
                break;
            }
            this.statements.add(cs);
            if ((cs.val == 185 || cs.val == 161) && cs.p1 < this.jumpTable) {
                this.jumpTable = cs.p1;
                max = this.procOffset + this.jumpTable;
            }
            ptr += cs.length;
lbl26:
            // 2 sources

            ** while (ptr < max)
        }
lbl27:
        // 3 sources

        if (this.statements.size() > 1) {
            lastStatement = this.statements.get(this.statements.size() - 1);
            secondLastStatement = this.statements.get(this.statements.size() - 2);
            if (lastStatement.val == 0 && (secondLastStatement.val == 214 || secondLastStatement.val == 193 || secondLastStatement.val == 173)) {
                this.statements.remove(this.statements.size() - 1);
            }
        }
        actualEnd = this.procOffset - this.codeEnd - 4;
        for (PascalCodeStatement cs : this.statements) {
            if (cs.ptr == actualEnd) {
                cs.jumpTarget = true;
                continue;
            }
            block2: for (PascalCodeStatement.Jump cj : cs.jumps) {
                for (PascalCodeStatement cs2 : this.statements) {
                    if (cs2.ptr != cj.addressTo) continue;
                    cs2.jumpTarget = true;
                    continue block2;
                }
            }
        }
    }

    public List<PascalCodeStatement> extractStrings() {
        this.decode();
        ArrayList<PascalCodeStatement> strings = new ArrayList<PascalCodeStatement>();
        for (PascalCodeStatement cs : this.statements) {
            if (cs.val != 166) continue;
            strings.add(cs);
        }
        return strings;
    }

    public String toString() {
        if (!this.valid) {
            return "";
        }
        this.decode();
        StringBuilder text = new StringBuilder("\nProcedure Header\n================\n\n");
        text.append(String.format("Level.......%5d     %02X%n", this.procLevel, this.procLevel & 0xFF));
        text.append(String.format("Proc no.....%5d     %02X%n", this.procedureNo, this.procedureNo));
        text.append(String.format("Code entry..%5d   %04X  (%04X - %04X = %04X)%n", this.codeStart, this.codeStart, this.procOffset - 2, this.codeStart, this.procOffset - this.codeStart - 2));
        text.append(String.format("Code exit...%5d   %04X", this.codeEnd, this.codeEnd));
        if (this.codeEnd > 0) {
            text.append(String.format("  (%04X - %04X = %04X)%n", this.procOffset - 4, this.codeEnd, this.procOffset - this.codeEnd - 4));
        } else {
            text.append(String.format("%n", new Object[0]));
        }
        text.append(String.format("Parm size...%5d   %04X%n", this.parmSize, this.parmSize));
        text.append(String.format("Data size...%5d   %04X%n%n", this.dataSize, this.dataSize));
        text.append("Procedure Code\n==============\n\n");
        int ptr = this.procOffset - this.codeStart - 2;
        if (this.codeEnd == 0) {
            if (this.assembler != null) {
                text.append(String.valueOf(this.assembler.getAssembler()) + "\n");
            } else {
                text.append("Null assembler in PascalProcedure");
            }
        } else {
            for (PascalCodeStatement cs : this.statements) {
                text.append(cs);
            }
        }
        return text.toString();
    }
}

