/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.PascalConstants;
import com.bytezone.diskbrowser.applefile.PascalSegment;
import com.bytezone.diskbrowser.applefile.SegmentDictionary;
import com.bytezone.diskbrowser.utilities.FileFormatException;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PascalCode
extends AbstractFile
implements PascalConstants,
Iterable<PascalSegment> {
    private final List<PascalSegment> segments = new ArrayList<PascalSegment>(16);
    private final String comment;

    public static void print() {
        int i = 0;
        while (i < 216) {
            System.out.printf("%3d  %d  %3s  %s%n", i + 128, PascalConstants.mnemonicSize[i], PascalConstants.mnemonics[i], PascalConstants.descriptions[i]);
            ++i;
        }
    }

    public PascalCode(String name, byte[] buffer, int blockOffset) {
        super(name, buffer);
        SegmentDictionary segmentDictionary = new SegmentDictionary(name, buffer);
        if (!segmentDictionary.isValid()) {
            throw new FileFormatException("Error in PascalSegment");
        }
        int nonameCounter = 0;
        int i = 0;
        while (i < 16) {
            String codeName = HexFormatter.getString(buffer, 64 + i * 8, 8).trim();
            int size = Utility.getShort(buffer, i * 4 + 2);
            if (codeName.length() == 0 && size > 0) {
                codeName = "<NULL" + ++nonameCounter + ">";
            }
            if (size > 0) {
                PascalSegment pascalSegment = new PascalSegment(codeName, buffer, i, blockOffset);
                this.segments.add(pascalSegment);
            }
            ++i;
        }
        this.comment = HexFormatter.getPascalString(buffer, 432);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(this.getHeader());
        text.append("Segment Dictionary\n==================\n\n");
        text.append("Slot Addr Blks Byte   Name     Kind            Txt Seg Mch Ver I/S I/S Disk:Block\n");
        text.append("---- ---- ---- ----  --------  --------------- --- --- --- --- --- --- ---------------------\n");
        for (PascalSegment segment : this.segments) {
            text.append(String.valueOf(segment.toText()) + "\n");
        }
        text.append("\nComment : " + this.comment);
        return text.toString();
    }

    @Override
    public Iterator<PascalSegment> iterator() {
        return this.segments.iterator();
    }
}

