/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class PascalArea
extends AbstractFile {
    int size;
    int volumes;
    String ppmName;
    int start;
    int length;
    int defaultUnit;
    boolean writeProtected;
    int oldDriver;

    public PascalArea(String name, byte[] buffer) {
        super(name, buffer);
        this.size = Utility.getShort(buffer, 0);
        this.volumes = Utility.getShort(buffer, 2);
        this.ppmName = HexFormatter.getPascalString(buffer, 4);
        this.start = Utility.getShort(buffer, 8);
        this.length = Utility.getShort(buffer, 11);
        this.defaultUnit = buffer[13] & 0xFF;
        this.oldDriver = Utility.getShort(buffer, 14);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder(this.getHeader());
        text.append(String.format("Size ............. %04X  (%<,d)%n", this.size));
        text.append(String.format("Volumes .......... %04X%n", this.volumes));
        text.append(String.format("PPM .............. %s%n", this.ppmName));
        text.append(String.format("Start ............ %04X  (%<,d)%n", this.start));
        text.append(String.format("Length ........... %04X  (%<,d)%n", this.length));
        text.append(String.format("Default Unit ..... %d%n", this.defaultUnit));
        text.append(String.format("Write Protected .. %s%n", this.writeProtected ? "True" : "False"));
        text.append(String.format("Old driver ....... %04X  (%<,d)%n", this.oldDriver));
        return text.toString();
    }
}

