/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;

public class MagicWindowText
extends AbstractFile {
    public MagicWindowText(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name : " + this.name + "\n");
        text.append(String.format("End of file   : %,8d%n%n", this.buffer.length));
        int ptr = 256;
        while (ptr < this.buffer.length && this.buffer[ptr] != 0) {
            String line = this.getLine(ptr);
            text.append(String.valueOf(line) + "\n");
            if ((ptr += line.length() + 1) >= this.buffer.length || this.buffer[ptr] != 10) continue;
            ++ptr;
        }
        return text.toString();
    }

    private String getLine(int ptr) {
        StringBuilder line = new StringBuilder();
        while (ptr < this.buffer.length && this.buffer[ptr] != -115 && this.buffer[ptr] != 0) {
            line.append((char)(this.buffer[ptr++] & 0x7F));
        }
        return line.toString();
    }
}

