/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.Palette;
import com.bytezone.diskbrowser.applefile.PaletteFactory;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.awt.Color;
import java.awt.image.DataBuffer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;

public abstract class HiResImage
extends AbstractFile {
    static final String[] auxTypes = new String[]{"Paintworks Packed SHR Image", "Packed Super Hi-Res Image", "Super Hi-Res Image (Apple Preferred Format)", "Packed QuickDraw II PICT File", "Packed Super Hi-Res 3200 color image", "DreamGraphix"};
    static final int COLOR_TABLE_SIZE = 32;
    static final int COLOR_TABLE_OFFSET_AUX_0 = 32256;
    static final int COLOR_TABLE_OFFSET_AUX_2 = 32000;
    public static final int FADDEN_AUX = 32870;
    private byte[] fourBuf = new byte[4];
    private ColorTable defaultColorTable320 = new ColorTable(0, 0);
    private ColorTable defaultColorTable640 = new ColorTable(0, 128);
    static PaletteFactory paletteFactory = new PaletteFactory();
    static final byte[] pngHeader = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    static boolean colourQuirks;
    static boolean monochrome;
    int fileType;
    int auxType;
    int eof;
    int paletteIndex;
    String failureReason = "";

    public HiResImage(String name, byte[] buffer) {
        super(name, buffer);
    }

    public HiResImage(String name, byte[] buffer, int loadAddress) {
        this(name, buffer, loadAddress, false);
    }

    public HiResImage(String name, byte[] buffer, int loadAddress, boolean scrunched) {
        super(name, buffer);
        this.loadAddress = loadAddress;
        if (scrunched) {
            this.buffer = this.unscrunch(buffer);
        }
    }

    public HiResImage(String name, byte[] buffer, int fileType, int auxType, int eof) {
        super(name, buffer);
        this.fileType = fileType;
        this.auxType = auxType;
        this.eof = eof;
    }

    public boolean isAnimation() {
        return this.fileType == 194;
    }

    protected void createImage() {
        if (!this.failureReason.isEmpty()) {
            return;
        }
        if (HiResImage.isGif(this.buffer) || HiResImage.isPng(this.buffer) || HiResImage.isBmp(this.buffer) || HiResImage.isTiff(this.buffer)) {
            this.makeImage();
        } else if (monochrome) {
            this.createMonochromeImage();
        } else {
            this.createColourImage();
        }
    }

    abstract void createMonochromeImage();

    abstract void createColourImage();

    public void checkPalette() {
        if (!monochrome && this.paletteIndex != paletteFactory.getCurrentPaletteIndex()) {
            this.createImage();
        }
    }

    public void setPalette() {
        if (!monochrome) {
            this.createImage();
        }
    }

    public void setColourQuirks(boolean value) {
        if (colourQuirks == value) {
            return;
        }
        colourQuirks = value;
        if (!monochrome) {
            this.createImage();
        }
    }

    public void setMonochrome(boolean value) {
        if (monochrome == value) {
            return;
        }
        monochrome = value;
        this.createImage();
    }

    public static void setDefaultColourQuirks(boolean value) {
        colourQuirks = value;
    }

    public static void setDefaultMonochrome(boolean value) {
        monochrome = value;
    }

    @Override
    public String getText() {
        String auxText = "";
        StringBuilder text = new StringBuilder();
        text.append(String.format("Image File : %s%nFile type  : $%02X    %s%n", this.name, this.fileType, ProdosConstants.fileTypes[this.fileType]));
        block0 : switch (this.fileType) {
            case 8: {
                if (this.auxType < 16384) {
                    auxText = "Apple II Graphics File";
                    byte mode = this.buffer[120];
                    System.out.println("Prodos PICT, mode=" + mode);
                    break;
                }
                if (this.auxType == 16384) {
                    auxText = "Packed Hi-Res File";
                    break;
                }
                if (this.auxType == 16385) {
                    auxText = "Packed Double Hi-Res File";
                    break;
                }
                if (this.auxType == 32870) {
                    auxText = "Fadden Hi-Res File";
                    break;
                }
                auxText = "Unknown aux: " + this.auxType;
                break;
            }
            case 192: {
                if (this.auxType == 32773) {
                    auxText = auxTypes[5];
                    break;
                }
                auxText = this.auxType > 4 ? "Unknown aux: " + this.auxType : auxTypes[this.auxType];
                break;
            }
            case 193: {
                switch (this.auxType) {
                    case 0: 
                    case 66: 
                    case 67: 
                    case 8192: {
                        String string = "Super Hi-res Screen Image";
                        break block0;
                    }
                    case 1: {
                        String string = "QuickDraw PICT File";
                        break block0;
                    }
                    case 2: {
                        String string = "Super Hi-Res 3200 color image";
                        break block0;
                    }
                    default: {
                        String string = auxText = "Unknown aux: " + this.auxType;
                    }
                }
            }
        }
        if (!auxText.isEmpty()) {
            text.append(String.format("Aux type   : $%04X  %s%n", this.auxType, auxText));
        }
        text.append(String.format("File size  : %,d%n", this.buffer.length));
        text.append(String.format("EOF        : %,d%n", this.eof));
        if (!this.failureReason.isEmpty()) {
            text.append(String.format("Failure    : %s%n", this.failureReason));
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    int mode320Line(int ptr, int element, int dataWidth, ColorTable colorTable, DataBuffer dataBuffer, int imageWidth) {
        if (colorTable == null) {
            colorTable = this.defaultColorTable320;
        }
        int i = 0;
        while (i < dataWidth) {
            if (ptr >= this.buffer.length) {
                System.out.printf("too big: %d  %d%n", ptr, this.buffer.length);
                return ptr;
            }
            int left = (this.buffer[ptr] & 0xF0) >>> 4;
            int right = this.buffer[ptr++] & 0xF;
            int rgbLeft = colorTable.entries[left].color.getRGB();
            int rgbRight = colorTable.entries[right].color.getRGB();
            this.draw(dataBuffer, element + imageWidth, rgbLeft, rgbLeft, rgbRight, rgbRight);
            element = this.draw(dataBuffer, element, rgbLeft, rgbLeft, rgbRight, rgbRight);
            ++i;
        }
        return ptr;
    }

    int mode640Line(int ptr, int element, int dataWidth, ColorTable colorTable, DataBuffer dataBuffer, int imageWidth) {
        if (colorTable == null) {
            colorTable = this.defaultColorTable640;
        }
        int i = 0;
        while (i < dataWidth) {
            int p1 = (this.buffer[ptr] & 0xC0) >>> 6;
            int p2 = (this.buffer[ptr] & 0x30) >> 4;
            int p3 = (this.buffer[ptr] & 0xC) >> 2;
            int p4 = this.buffer[ptr++] & 3;
            int rgb1 = colorTable.entries[p1 + 8].color.getRGB();
            int rgb2 = colorTable.entries[p2 + 12].color.getRGB();
            int rgb3 = colorTable.entries[p3].color.getRGB();
            int rgb4 = colorTable.entries[p4 + 4].color.getRGB();
            this.draw(dataBuffer, element + imageWidth, rgb1, rgb2, rgb3, rgb4);
            element = this.draw(dataBuffer, element, rgb1, rgb2, rgb3, rgb4);
            ++i;
        }
        return ptr;
    }

    int draw(DataBuffer dataBuffer, int element, int ... rgbList) {
        if (dataBuffer.getSize() < rgbList.length + element) {
            System.out.printf("Bollocks: %d %d %d%n", dataBuffer.getSize(), rgbList.length, element);
            return element;
        }
        int[] nArray = rgbList;
        int n = rgbList.length;
        int n2 = 0;
        while (n2 < n) {
            int rgb = nArray[n2];
            dataBuffer.setElem(element++, rgb);
            ++n2;
        }
        return element;
    }

    int unpack(byte[] buffer, int ptr, int max, byte[] newBuf, int newPtr) {
        int savePtr = newPtr;
        block6: while (ptr < max - 1) {
            int type = (buffer[ptr] & 0xC0) >>> 6;
            int count = (buffer[ptr++] & 0x3F) + 1;
            switch (type) {
                case 0: {
                    while (count-- != 0 && newPtr < newBuf.length && ptr < max) {
                        newBuf[newPtr++] = buffer[ptr++];
                    }
                    continue block6;
                }
                case 1: {
                    byte b = buffer[ptr++];
                    while (count-- != 0 && newPtr < newBuf.length) {
                        newBuf[newPtr++] = b;
                    }
                    continue block6;
                }
                case 2: {
                    int i = 0;
                    while (i < 4) {
                        this.fourBuf[i] = ptr < max ? buffer[ptr++] : (byte)0;
                        ++i;
                    }
                    while (count-- != 0) {
                        i = 0;
                        while (i < 4) {
                            if (newPtr < newBuf.length) {
                                newBuf[newPtr++] = this.fourBuf[i];
                            }
                            ++i;
                        }
                    }
                    continue block6;
                }
                case 3: {
                    byte b = buffer[ptr++];
                    count *= 4;
                    while (count-- != 0 && newPtr < newBuf.length) {
                        newBuf[newPtr++] = b;
                    }
                    continue block6;
                }
            }
        }
        return newPtr - savePtr;
    }

    String debug(byte[] buffer, int ptr, int length) {
        int size = 0;
        int max = ptr + length;
        StringBuffer text = new StringBuffer();
        while (ptr < max) {
            int type = (buffer[ptr] & 0xC0) >>> 6;
            int count = (buffer[ptr++] & 0x3F) + 1;
            text.append(String.format("%04X/%04d: %02X  (%d,%2d)  ", ptr - 1, size, buffer[ptr - 1], type, count));
            if (type == 0) {
                text.append(String.format("%s%n", HexFormatter.getHexString(buffer, ptr, count)));
                ptr += count;
                size += count;
                continue;
            }
            if (type == 1) {
                text.append(String.format("%s%n", HexFormatter.getHexString(buffer, ptr, 1)));
                ++ptr;
                size += count;
                continue;
            }
            if (type == 2) {
                text.append(String.format("%s%n", HexFormatter.getHexString(buffer, ptr, 4)));
                ptr += 4;
                size += count * 4;
                continue;
            }
            text.append(String.format("%s%n", HexFormatter.getHexString(buffer, ptr, 1)));
            ++ptr;
            size += count * 4;
        }
        return text.toString();
    }

    int calculateBufferSize(byte[] buffer, int ptr) {
        int size = 0;
        while (ptr < buffer.length) {
            int type = (buffer[ptr] & 0xC0) >>> 6;
            int count = (buffer[ptr++] & 0x3F) + 1;
            if (type == 0) {
                ptr += count;
                size += count;
                continue;
            }
            if (type == 1) {
                ++ptr;
                size += count;
                continue;
            }
            if (type == 2) {
                ptr += 4;
                size += count * 4;
                continue;
            }
            ++ptr;
            size += count * 4;
        }
        return size;
    }

    private byte[] unscrunch(byte[] src) {
        byte[] dst = new byte[8192];
        int p1 = 0;
        int p2 = 0;
        while (p1 < dst.length) {
            byte b;
            if ((b = src[p2++]) == -128 || b == -1) {
                b = (byte)(b & 0x7F);
                int rpt = src[p2++];
                int i = 0;
                while (i < rpt) {
                    dst[p1++] = b;
                    ++i;
                }
                continue;
            }
            dst[p1++] = b;
        }
        return dst;
    }

    protected void makeImage() {
        try {
            this.image = ImageIO.read(new ByteArrayInputStream(this.buffer));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (IndexOutOfBoundsException e) {
            System.out.println("Error in makeImage()");
            System.out.println(e.getMessage());
        }
    }

    public static boolean isGif(byte[] buffer) {
        if (buffer.length < 6) {
            return false;
        }
        String text = new String(buffer, 0, 6);
        return text.equals("GIF89a") || text.equals("GIF87a");
    }

    public static boolean isPng(byte[] buffer) {
        if (buffer.length < pngHeader.length) {
            return false;
        }
        int i = 0;
        while (i < pngHeader.length) {
            if (pngHeader[i] != buffer[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean isTiff(byte[] buffer) {
        if (buffer.length < 3) {
            return false;
        }
        String text = new String(buffer, 0, 2);
        if (!"II".equals(text) && !"MM".equals(text)) {
            return false;
        }
        return buffer[2] == 42;
    }

    public static boolean isBmp(byte[] buffer) {
        if (buffer.length < 26) {
            return false;
        }
        String text = new String(buffer, 0, 2);
        int size = Utility.getLong(buffer, 2);
        return text.equals("BM") && size <= buffer.length;
    }

    public static boolean isAPP(byte[] buffer) {
        if (buffer.length < 4) {
            return false;
        }
        return buffer[0] == -63 && buffer[1] == -48 && buffer[2] == -48 && buffer[3] == 0;
    }

    public static PaletteFactory getPaletteFactory() {
        return paletteFactory;
    }

    public static List<Palette> getPalettes() {
        return paletteFactory.getPalettes();
    }

    class ColorEntry {
        int value;
        Color color;

        public ColorEntry(int red, int green, int blue) {
            this.value = red << 8 | green << 4 | blue;
            this.color = new Color(red, green, blue);
        }

        public ColorEntry(byte[] data, int offset) {
            this.value = Utility.getShort(data, offset);
            int red = (this.value >> 8 & 0xF) * 17;
            int green = (this.value >> 4 & 0xF) * 17;
            int blue = (this.value & 0xF) * 17;
            this.color = new Color(red, green, blue);
        }

        public String toString() {
            return String.format("ColorEntry: %04X", this.value);
        }
    }

    class ColorTable {
        private int id;
        ColorEntry[] entries = new ColorEntry[16];

        public ColorTable(int id, int mode) {
            this.id = id;
            if ((mode & 0x80) == 0) {
                this.entries[0] = new ColorEntry(0, 0, 0);
                this.entries[1] = new ColorEntry(7, 7, 7);
                this.entries[2] = new ColorEntry(8, 4, 1);
                this.entries[3] = new ColorEntry(7, 2, 12);
                this.entries[4] = new ColorEntry(0, 0, 15);
                this.entries[5] = new ColorEntry(0, 8, 0);
                this.entries[6] = new ColorEntry(15, 7, 0);
                this.entries[7] = new ColorEntry(13, 0, 0);
                this.entries[8] = new ColorEntry(15, 10, 9);
                this.entries[9] = new ColorEntry(15, 15, 0);
                this.entries[10] = new ColorEntry(0, 14, 0);
                this.entries[11] = new ColorEntry(4, 13, 15);
                this.entries[12] = new ColorEntry(13, 10, 15);
                this.entries[13] = new ColorEntry(7, 8, 15);
                this.entries[14] = new ColorEntry(12, 12, 12);
                this.entries[15] = new ColorEntry(15, 15, 15);
            } else {
                this.entries[0] = new ColorEntry(0, 0, 0);
                this.entries[1] = new ColorEntry(0, 0, 15);
                this.entries[2] = new ColorEntry(15, 15, 0);
                this.entries[3] = new ColorEntry(15, 15, 15);
                this.entries[4] = new ColorEntry(0, 0, 0);
                this.entries[5] = new ColorEntry(13, 0, 0);
                this.entries[6] = new ColorEntry(0, 14, 0);
                this.entries[7] = new ColorEntry(15, 15, 15);
                this.entries[0] = new ColorEntry(0, 0, 0);
                this.entries[1] = new ColorEntry(0, 0, 15);
                this.entries[2] = new ColorEntry(15, 15, 0);
                this.entries[3] = new ColorEntry(15, 15, 15);
                this.entries[4] = new ColorEntry(0, 0, 0);
                this.entries[5] = new ColorEntry(13, 0, 0);
                this.entries[6] = new ColorEntry(0, 14, 0);
                this.entries[7] = new ColorEntry(15, 15, 15);
            }
        }

        public ColorTable(int id, byte[] data, int offset) {
            this.id = id;
            int i = 0;
            while (i < 16) {
                this.entries[i] = new ColorEntry(data, offset);
                offset += 2;
                ++i;
            }
        }

        String toLine() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("%02X", this.id));
            int i = 0;
            while (i < 16) {
                text.append(String.format("  %04X", this.entries[i].value));
                ++i;
            }
            return text.toString();
        }

        void reverse() {
            int i = 0;
            while (i < 8) {
                ColorEntry temp = this.entries[i];
                this.entries[i] = this.entries[15 - i];
                this.entries[15 - i] = temp;
                ++i;
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("%3d ColorTable%n", this.id));
            int i = 0;
            while (i < 8) {
                text.append(String.format("  %2d: %04X", i, this.entries[i].value));
                ++i;
            }
            text.append("\n");
            i = 8;
            while (i < 16) {
                text.append(String.format("  %2d: %04X", i, this.entries[i].value));
                ++i;
            }
            return text.toString();
        }
    }

    class DirEntry {
        int numBytes;
        int mode;

        public DirEntry(byte[] data, int offset) {
            this.numBytes = Utility.getShort(data, offset);
            this.mode = Utility.getShort(data, offset + 2);
        }

        public String toString() {
            return String.format("Bytes: %5d, mode: %02X", this.numBytes, this.mode);
        }
    }
}

