/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.CharacterList;
import java.awt.image.DataBuffer;

public class FontFile
extends CharacterList {
    private static final int charsX = 16;

    public FontFile(String name, byte[] buffer, int address) {
        super(name, buffer);
        this.loadAddress = address;
        int ptr = 0;
        while (ptr < buffer.length) {
            this.characters.add(new FontFileCharacter(buffer, ptr));
            ptr += 8;
        }
        this.buildImage(3, 3, 3, 3, 7, 8, 16);
    }

    public static boolean isFont(byte[] buffer) {
        if (buffer.length % 8 != 0) {
            return false;
        }
        int i = 0;
        while (i < 8) {
            if (buffer[i] != 0 && buffer[i] != 127) {
                return false;
            }
            ++i;
        }
        return true;
    }

    class FontFileCharacter
    extends CharacterList.Character {
        public FontFileCharacter(byte[] buffer, int ptr) {
            super(7, 8);
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            int element = 0;
            int i = 0;
            while (i < 8) {
                int value = buffer[ptr++] & 0xFF;
                int j = 0;
                while (j < 7) {
                    dataBuffer.setElem(element++, (value & 1) == 0 ? 0 : 255);
                    value >>>= 1;
                    ++j;
                }
                ++i;
            }
        }
    }
}

