/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;

public class FinderData
extends AbstractFile {
    int version;

    public FinderData(String name, byte[] buffer) {
        super(name, buffer);
        this.version = this.buffer[0];
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append("Name : " + this.name + "\n\n");
        text.append("\n\n");
        if (this.version == 1) {
            int ptr = 16;
            text.append(HexFormatter.getHexString(this.buffer, 0, ptr));
            text.append("\n\n");
            while (this.buffer[ptr] != 0) {
                String line = HexFormatter.getHexString(this.buffer, ptr, 6);
                text.append(String.valueOf(line) + "  ");
                String name = HexFormatter.getPascalString(this.buffer, ptr + 6);
                text.append(String.valueOf(name) + "\n");
                ptr += 22;
            }
        } else if (this.version == 2) {
            int totFiles = this.buffer[34];
            int ptr = 42;
            text.append(HexFormatter.format(this.buffer, 0, ptr));
            text.append("\n\n");
            int i = 0;
            while (i < totFiles) {
                String line = HexFormatter.getHexString(this.buffer, ptr, 8);
                text.append(String.valueOf(line) + "  ");
                String name = HexFormatter.getPascalString(this.buffer, ptr += 8);
                text.append(String.format("%-20s ", name));
                ptr += name.length() + 1;
                text.append(String.format("%02X%n", this.buffer[ptr++]));
                ++i;
            }
        } else {
            text.append(String.format("Unknown finder data version: %d%n", this.version));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

