/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class FileTypeDescriptorTable
extends AbstractFile {
    int versionMajor;
    int versionMinor;
    int flags;
    int numEntries;
    int spareWord;
    int indexRecordSize;
    int offsetToIdx;
    private final List<IndexRecord> indexRecords = new ArrayList<IndexRecord>();

    public FileTypeDescriptorTable(String name, byte[] buffer) {
        super(name, buffer);
        this.versionMajor = buffer[0] & 0xFF;
        this.versionMinor = buffer[1] & 0xFF;
        this.flags = Utility.getShort(buffer, 2);
        this.numEntries = Utility.getShort(buffer, 4);
        this.spareWord = Utility.getShort(buffer, 6);
        this.indexRecordSize = Utility.getShort(buffer, 8);
        int ptr = this.offsetToIdx = Utility.getShort(buffer, 10);
        int i = 0;
        while (i < this.numEntries) {
            this.indexRecords.add(new IndexRecord(buffer, ptr));
            ptr += this.indexRecordSize;
            ++i;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Name : " + this.name + "\n\n");
        text.append("File Type Descriptor Table\n\n");
        text.append(String.format("Version ........... %d.%d%n", this.versionMajor, this.versionMinor));
        text.append(String.format("Flags ............. %04X%n", this.flags));
        text.append(String.format("NumEntries ........ %d%n", this.numEntries));
        text.append(String.format("SpareWord ......... %d%n", this.spareWord));
        text.append(String.format("IndexRecordSize ... %d%n", this.indexRecordSize));
        text.append(String.format("OffsetToIdx ....... %d%n%n", this.offsetToIdx));
        text.append("Type     Aux   Flags   Offset   String\n");
        for (IndexRecord indexRecord : this.indexRecords) {
            text.append(String.format("%04X    %04X    %04X    %04X    %s%n", indexRecord.fileType, indexRecord.auxType, indexRecord.flags, indexRecord.offset, indexRecord.string));
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    class IndexRecord {
        int fileType;
        int auxType;
        int flags;
        int offset;
        String string;

        public IndexRecord(byte[] buffer, int offset) {
            this.fileType = Utility.getShort(buffer, offset);
            this.auxType = Utility.getLong(buffer, offset + 2);
            this.flags = Utility.getShort(buffer, offset + 6);
            this.offset = Utility.getShort(buffer, offset + 8);
            this.string = HexFormatter.getPascalString(buffer, this.offset);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            text.append(String.format("File type ...... %d%n", this.fileType));
            text.append(String.format("Aux type ....... %04X%n", this.auxType));
            text.append(String.format("Flags .......... %04X%n", this.flags));
            text.append(String.format("Offset ......... %04X%n", this.offset));
            text.append(String.format("String ......... %s%n", this.string));
            return text.toString();
        }
    }
}

