/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

public class ExoBufferC {
    private static int PBIT_BITS_ORDER_BE = 0;
    private static int PBIT_BITS_COPY_GT_7 = 1;
    private static int PBIT_IMPL_1LITERAL = 2;
    private static int PBIT_BITS_ALIGN_START = 3;
    private static int PBIT_4_OFFSET_TABLES = 4;
    private static int PFLAG_BITS_ORDER_BE = 1 << PBIT_BITS_ORDER_BE;
    private static int PFLAG_BITS_COPY_GT_7 = 1 << PBIT_BITS_COPY_GT_7;
    private static int PFLAG_IMPL_1LITERAL = 1 << PBIT_IMPL_1LITERAL;
    private static int PFLAG_BITS_ALIGN_START = 1 << PBIT_BITS_ALIGN_START;
    private static int PFLAG_4_OFFSET_TABLES = 1 << PBIT_4_OFFSET_TABLES;
    byte[] outBuffer = new byte[50000];

    public ExoBufferC(byte[] inBuffer) {
        this.reverse(inBuffer);
        DecCtx decCtx = new DecCtx();
        this.decCtxInit(decCtx, inBuffer, this.outBuffer, 23);
        this.decCtxDecrunch(decCtx);
        if (decCtx.outPos != this.outBuffer.length) {
            byte[] outBuffer2 = new byte[decCtx.outPos];
            System.arraycopy(this.outBuffer, 0, outBuffer2, 0, outBuffer2.length);
            this.outBuffer = outBuffer2;
        }
        this.reverse(this.outBuffer);
    }

    private void reverse(byte[] inBuffer) {
        int lo = 0;
        int hi = inBuffer.length - 1;
        while (lo < hi) {
            byte temp = inBuffer[lo];
            inBuffer[lo++] = inBuffer[hi];
            inBuffer[hi--] = temp;
        }
    }

    public byte[] getExpandedBuffer() {
        return this.outBuffer;
    }

    private int bitBufRotate(DecCtx decCtx, int carry) {
        int carryOut;
        if ((decCtx.flagsProto & PFLAG_BITS_ORDER_BE) != 0) {
            carryOut = (decCtx.bitBuffer & 0x80) == 0 ? 0 : 1;
            decCtx.bitBuffer = decCtx.bitBuffer << 1 & 0xFF;
            if (carry != 0) {
                decCtx.bitBuffer |= 1;
            }
        } else {
            carryOut = decCtx.bitBuffer & 1;
            decCtx.bitBuffer = decCtx.bitBuffer >>> 1 & 0xFF;
            if (carry != 0) {
                decCtx.bitBuffer |= 0x80;
            }
        }
        return carryOut;
    }

    private int getByte(DecCtx decCtx) {
        decCtx.bitsRead += 8;
        int c = decCtx.inBuffer[decCtx.inPos++] & 0xFF;
        return c;
    }

    private int getBits(DecCtx decCtx, int count) {
        int byteCopy = 0;
        int value = 0;
        if ((decCtx.flagsProto & PFLAG_BITS_COPY_GT_7) != 0) {
            while (count > 7) {
                byteCopy = count >>> 3;
                count &= 7;
            }
        }
        while (count-- > 0) {
            int carry = this.bitBufRotate(decCtx, 0);
            if (decCtx.bitBuffer == 0) {
                decCtx.bitBuffer = this.getByte(decCtx);
                decCtx.bitsRead -= 8;
                carry = this.bitBufRotate(decCtx, 1);
            }
            value <<= 1;
            value |= carry;
            ++decCtx.bitsRead;
        }
        while (byteCopy-- > 0) {
            value <<= 8;
            value |= this.getByte(decCtx);
        }
        return value;
    }

    private int getGammaCode(DecCtx decCtx) {
        int gammaCode = 0;
        while (this.getBits(decCtx, 1) == 0) {
            ++gammaCode;
        }
        return gammaCode;
    }

    private int getCooked(DecCtx decCtx, int index) {
        int base = decCtx.table.tableLo[index] | decCtx.table.tableHi[index] << 8;
        return base + this.getBits(decCtx, decCtx.table.tableBi[index]);
    }

    private void tableInit(DecCtx decCtx, DecTable decTable) {
        int end;
        int a = 0;
        int b = 0;
        decTable.tableBit[0] = 2;
        decTable.tableBit[1] = 4;
        decTable.tableBit[2] = 4;
        if ((decCtx.flagsProto & PFLAG_4_OFFSET_TABLES) != 0) {
            end = 68;
            decTable.tableBit[3] = 4;
            decTable.tableOff[0] = 64;
            decTable.tableOff[1] = 48;
            decTable.tableOff[2] = 32;
            decTable.tableOff[3] = 16;
        } else {
            end = 52;
            decTable.tableOff[0] = 48;
            decTable.tableOff[1] = 32;
            decTable.tableOff[2] = 16;
        }
        int i = 0;
        while (i < end) {
            a = (i & 0xF) != 0 ? (a += 1 << b) : 1;
            decTable.tableLo[i] = a & 0xFF;
            decTable.tableHi[i] = a >>> 8;
            if ((decCtx.flagsProto & PFLAG_BITS_COPY_GT_7) != 0) {
                b = this.getBits(decCtx, 3);
                b |= this.getBits(decCtx, 1) << 3;
            } else {
                b = this.getBits(decCtx, 4);
            }
            decTable.tableBi[i] = b;
            ++i;
        }
    }

    private void tableDump(DecTable table) {
        int i = 0;
        while (i < 16) {
            System.out.printf("%X", table.tableBi[i]);
            ++i;
        }
        int j = 0;
        while (j < 3) {
            System.out.printf(",", new Object[0]);
            int start = table.tableOff[j];
            int end = start + (1 << table.tableBit[j]);
            int i2 = start;
            while (i2 < end) {
                System.out.printf("%X", table.tableBi[i2]);
                ++i2;
            }
            ++j;
        }
        System.out.println();
    }

    private void decCtxInit(DecCtx decCtx, byte[] inBuffer, byte[] outBuffer, int flags) {
        decCtx.bitsRead = 0;
        decCtx.inBuffer = inBuffer;
        decCtx.inEnd = inBuffer.length;
        decCtx.inPos = 2;
        decCtx.flagsProto = flags;
        decCtx.outBuffer = outBuffer;
        decCtx.outPos = 0;
        decCtx.bitBuffer = (decCtx.flagsProto & PFLAG_BITS_ALIGN_START) != 0 ? 0 : this.getByte(decCtx);
        this.tableInit(decCtx, decCtx.table);
    }

    private void decCtxDecrunch(DecCtx decCtx) {
        int literal;
        int len;
        int threshold;
        int src = 0;
        int n = threshold = (decCtx.flagsProto & PFLAG_4_OFFSET_TABLES) != 0 ? 4 : 3;
        if ((decCtx.flagsProto & PFLAG_IMPL_1LITERAL) != 0) {
            len = 1;
            literal = 1;
            src = this.literal(decCtx, len, literal, src);
        }
        while (true) {
            literal = 0;
            if (this.getBits(decCtx, 1) != 0) {
                len = 1;
                literal = 1;
                src = this.literal(decCtx, len, literal, src);
                continue;
            }
            int val = this.getGammaCode(decCtx);
            if (val == 16) break;
            if (val == 17) {
                len = this.getBits(decCtx, 16);
                literal = 1;
                src = this.literal(decCtx, len, literal, src);
                continue;
            }
            len = this.getCooked(decCtx, val);
            int i = (len > threshold ? threshold : len) - 1;
            val = decCtx.table.tableOff[i] + this.getBits(decCtx, decCtx.table.tableBit[i]);
            int offset = this.getCooked(decCtx, val);
            src = decCtx.outPos - offset;
            src = this.literal(decCtx, len, literal, src);
        }
    }

    private int literal(DecCtx decCtx, int len, int literal, int src) {
        assert (len > 0);
        do {
            int val = literal == 0 ? decCtx.outBuffer[src++] : this.getByte(decCtx);
            decCtx.outBuffer[decCtx.outPos++] = (byte)(val & 0xFF);
        } while (--len > 0);
        return src;
    }

    class DecCtx {
        int inPos;
        int inEnd;
        int outPos;
        byte[] inBuffer;
        byte[] outBuffer;
        int bitBuffer;
        DecTable table;
        int bitsRead;
        int flagsProto;

        DecCtx() {
            this.table = new DecTable();
        }
    }

    class DecTable {
        int[] tableBit = new int[8];
        int[] tableOff = new int[8];
        int[] tableBi = new int[100];
        int[] tableLo = new int[100];
        int[] tableHi = new int[100];

        DecTable() {
        }
    }
}

