/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.Utility;

public class ExoBuffer {
    private static final int PFLAG_BITS_ORDER_BE = 1;
    private static final int PFLAG_BITS_COPY_GT_7 = 2;
    private static final int PFLAG_IMPL_1LITERAL = 4;
    private static final int PFLAG_BITS_ALIGN_START = 8;
    private static final int PFLAG_4_OFFSET_TABLES = 16;
    private byte[] inBuffer;
    private byte[] outBuffer;
    private int inPos;
    private int outPos;
    private int srcPtr;
    private int bitBuffer;
    private int flags;
    private int[] tableBit = new int[8];
    private int[] tableOff = new int[8];
    private int[] tableBi = new int[100];
    private int[] tableLo = new int[100];
    private int[] tableHi = new int[100];
    private static boolean debug = false;

    public ExoBuffer(byte[] inBuffer) {
        this.inBuffer = inBuffer;
        Utility.reverse(inBuffer);
        switch (Utility.getShortBigEndian(inBuffer, 0)) {
            case 24576: {
                this.outBuffer = new byte[8192];
                break;
            }
            case 32768: {
                this.outBuffer = new byte[16384];
                break;
            }
            case 40960: {
                this.outBuffer = new byte[32768];
                break;
            }
            case 24568: {
                return;
            }
            default: {
                System.out.printf("Invalid buffer size: %04X%n", Utility.getShortBigEndian(inBuffer, 0));
            }
        }
        this.decrunch();
        Utility.reverse(this.outBuffer);
    }

    public byte[] getExpandedBuffer() {
        return this.outBuffer;
    }

    public static boolean isExomizer(byte[] buffer, int auxType) {
        if (auxType != 8184 && auxType != 16376) {
            if (debug) {
                System.out.println("wrong auxType");
            }
            return false;
        }
        int address = Utility.getShort(buffer, buffer.length - 2);
        if (address != 24576 && address != 32768 && address != 40960) {
            if (debug) {
                System.out.printf("wrong address: %04X%n", address);
            }
            return false;
        }
        return true;
    }

    private int bitBufRotate(int carryIn) {
        int carryOut;
        if ((this.flags & 1) != 0) {
            carryOut = (this.bitBuffer & 0x80) >>> 7;
            this.bitBuffer = this.bitBuffer << 1 & 0xFF;
            if (carryIn != 0) {
                this.bitBuffer |= 1;
            }
        } else {
            carryOut = this.bitBuffer & 1;
            this.bitBuffer = this.bitBuffer >>> 1 & 0xFF;
            if (carryIn != 0) {
                this.bitBuffer |= 0x80;
            }
        }
        return carryOut;
    }

    private int getByte() {
        return this.inBuffer[this.inPos++] & 0xFF;
    }

    private int getBits(int count) {
        int byteCopy = 0;
        int value = 0;
        if ((this.flags & 2) != 0) {
            while (count > 7) {
                byteCopy = count >>> 3;
                count &= 7;
            }
        }
        while (count-- > 0) {
            int carry = this.bitBufRotate(0);
            if (this.bitBuffer == 0) {
                this.bitBuffer = this.getByte();
                carry = this.bitBufRotate(1);
            }
            value = value << 1 | carry;
        }
        while (byteCopy-- > 0) {
            value = value << 8 | this.getByte();
        }
        return value;
    }

    private void tableInit() {
        int end;
        int a = 0;
        int b = 0;
        this.tableBit[0] = 2;
        this.tableBit[1] = 4;
        this.tableBit[2] = 4;
        if ((this.flags & 0x10) != 0) {
            end = 68;
            this.tableBit[3] = 4;
            this.tableOff[0] = 64;
            this.tableOff[1] = 48;
            this.tableOff[2] = 32;
            this.tableOff[3] = 16;
        } else {
            end = 52;
            this.tableOff[0] = 48;
            this.tableOff[1] = 32;
            this.tableOff[2] = 16;
        }
        int i = 0;
        while (i < end) {
            a = (i & 0xF) != 0 ? (a += 1 << b) : 1;
            this.tableLo[i] = a & 0xFF;
            this.tableHi[i] = a >>> 8;
            if ((this.flags & 2) != 0) {
                b = this.getBits(3);
                b |= this.getBits(1) << 3;
            } else {
                b = this.getBits(4);
            }
            this.tableBi[i] = b;
            ++i;
        }
    }

    private void tableDump() {
        int i = 0;
        while (i < 16) {
            System.out.printf("%X", this.tableBi[i]);
            ++i;
        }
        int j = 0;
        while (j < 3) {
            System.out.printf(",", new Object[0]);
            int start = this.tableOff[j];
            int end = start + (1 << this.tableBit[j]);
            int i2 = start;
            while (i2 < end) {
                System.out.printf("%X", this.tableBi[i2]);
                ++i2;
            }
            ++j;
        }
        System.out.println();
    }

    private void decrunch() {
        boolean literal;
        int len;
        int threshold;
        this.inPos = 2;
        this.outPos = 0;
        this.flags = 23;
        this.bitBuffer = (this.flags & 8) != 0 ? 0 : this.getByte();
        this.tableInit();
        int n = threshold = (this.flags & 0x10) != 0 ? 4 : 3;
        if ((this.flags & 4) != 0) {
            len = 1;
            literal = true;
            this.copy(len, literal);
        }
        while (true) {
            if (this.getBits(1) == 1) {
                len = 1;
                literal = true;
            } else {
                int val = this.getGammaCode();
                if (val == 16) break;
                if (val == 17) {
                    len = this.getBits(16);
                    literal = true;
                } else {
                    len = this.getCooked(val);
                    literal = false;
                    int i = (len > threshold ? threshold : len) - 1;
                    this.srcPtr = this.outPos - this.getCooked(this.tableOff[i] + this.getBits(this.tableBit[i]));
                }
            }
            this.copy(len, literal);
        }
        assert (this.outPos == this.outBuffer.length);
    }

    private int getGammaCode() {
        int gammaCode = 0;
        while (this.getBits(1) == 0) {
            ++gammaCode;
        }
        return gammaCode;
    }

    private int getCooked(int index) {
        return (this.tableHi[index] << 8 | this.tableLo[index]) + this.getBits(this.tableBi[index]);
    }

    /*
     * Unable to fully structure code
     */
    private void copy(int len, boolean literal) {
        if (ExoBuffer.$assertionsDisabled || len > 0) ** GOTO lbl5
        throw new AssertionError();
lbl-1000:
        // 1 sources

        {
            val = literal != false ? this.getByte() : this.outBuffer[this.srcPtr++];
            this.outBuffer[this.outPos++] = (byte)(val & 255);
lbl5:
            // 2 sources

            ** while (len-- > 0)
        }
lbl6:
        // 1 sources

    }
}

