/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.utilities.CPU;

public class DoubleScrunchCPU
extends CPU {
    private byte mem_71D0;
    private byte mem_71D2;
    private byte mem_71D3;
    private byte mem_71D4;
    private int src;
    private int dst;
    private byte zp_00;
    private byte zp_01;
    private byte zp_26;
    private byte zp_27;
    private byte zp_E6;
    final byte[][] memory = new byte[2][8192];
    private byte[] packedBuffer;
    private int count;

    void unscrunch(byte[] buffer) {
        this.packedBuffer = buffer;
        this.src = 16384;
        this.dst = 8192;
        this.zp_00 = 0;
        this.zp_01 = (byte)64;
        this.zp_E6 = (byte)32;
        this.lda(this.zp_E6);
        this.ora((byte)4);
        this.zp_27 = this.sta();
        this.ldx((byte)1);
        this.mem_71D0 = this.stx();
        this.ldy((byte)0);
        this.mem_71D2 = this.sty();
        this.zp_26 = this.sty();
        while (true) {
            this.lda(this.packedBuffer, this.indirectY(this.src, this.zp_00, this.zp_01));
            this.php();
            this.zp_00 = this.inc(this.zp_00);
            if (this.zero) {
                this.zp_01 = this.inc(this.zp_01);
            }
            this.and((byte)127);
            this.mem_71D4 = this.sta();
            this.plp();
            if (this.negative ? this.copyBytes() : this.repeatBytes()) break;
            this.zp_00 = this.inc(this.zp_00);
            if (!this.zero) continue;
            this.zp_01 = this.inc(this.zp_01);
        }
    }

    private boolean repeatBytes() {
        this.lda(this.packedBuffer, this.indirectY(this.src, this.zp_00, this.zp_01));
        this.mem_71D3 = this.sta();
        do {
            this.lda(this.mem_71D3);
            this.storeByte();
            this.calculateScreenColumn();
            if (this.carry) {
                return true;
            }
            this.calculateNextScreenAddress();
            this.ldy(this.mem_71D4);
        } while (!this.zero);
        return false;
    }

    private boolean copyBytes() {
        while (true) {
            this.ldy((byte)0);
            this.lda(this.packedBuffer, this.indirectY(this.src, this.zp_00, this.zp_01));
            this.storeByte();
            this.calculateScreenColumn();
            if (this.carry) {
                return true;
            }
            this.calculateNextScreenAddress();
            this.ldy(this.mem_71D4);
            if (this.zero) {
                return false;
            }
            this.zp_00 = this.inc(this.zp_00);
            if (!this.zero) continue;
            this.zp_01 = this.inc(this.zp_01);
        }
    }

    private void storeByte() {
        this.mem_71D4 = this.dec(this.mem_71D4);
        this.ldy(this.mem_71D2);
        this.php();
        this.pha();
        this.tya();
        this.lsr();
        this.tay();
        this.pla();
        this.sta(this.memory[this.carry ? 1 : 0], this.indirectY(this.dst, this.zp_26, this.zp_27));
        this.plp();
    }

    private void calculateScreenColumn() {
        this.inx();
        this.inx();
        this.cpx((byte)-64);
        if (!this.carry) {
            return;
        }
        this.mem_71D0 = this.dec(this.mem_71D0);
        if (!this.negative) {
            assert (this.mem_71D0 == 0);
            this.ldx((byte)0);
            this.clc();
            return;
        }
        this.mem_71D2 = this.inc(this.mem_71D2);
        this.ldy(this.mem_71D2);
        this.cpy((byte)80);
        if (this.carry) {
            return;
        }
        this.ldx((byte)1);
        this.mem_71D0 = this.stx();
        this.clc();
    }

    private void calculateNextScreenAddress() {
        this.txa();
        this.and((byte)-64);
        this.zp_26 = this.sta();
        this.lsr();
        this.lsr();
        this.ora(this.zp_26);
        this.zp_26 = this.sta();
        this.txa();
        this.zp_27 = this.sta();
        this.asl();
        this.asl();
        this.asl();
        this.zp_27 = this.rol(this.zp_27);
        this.asl();
        this.zp_27 = this.rol(this.zp_27);
        this.asl();
        this.zp_26 = this.ror(this.zp_26);
        this.lda(this.zp_27);
        this.and((byte)31);
        this.ora(this.zp_E6);
        this.zp_27 = this.sta();
    }

    @Override
    protected String debugString() {
        return String.format("0: %02X %02X  26: %02X %02X  %02X %02X %02X %02X", this.zp_00, this.zp_01, this.zp_26, this.zp_27, this.mem_71D0, this.mem_71D2, this.mem_71D3, this.mem_71D4);
    }
}

