/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.ApplesoftBasicProgram;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.applefile.BasicFormatter;
import com.bytezone.diskbrowser.applefile.SourceLine;
import com.bytezone.diskbrowser.applefile.SubLine;
import com.bytezone.diskbrowser.gui.BasicPreferences;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class DebugBasicFormatter
extends BasicFormatter {
    int endPtr;

    public DebugBasicFormatter(ApplesoftBasicProgram program, BasicPreferences basicPreferences) {
        super(program, basicPreferences);
        this.endPtr = program.getEndPtr();
    }

    @Override
    public void append(StringBuilder text) {
        int loadAddress = this.getLoadAddress();
        for (SourceLine sourceLine : this.sourceLines) {
            text.append(String.format("%5d            %s%n", sourceLine.lineNumber, HexFormatter.formatNoHeader(this.buffer, sourceLine.linePtr, 4, loadAddress + sourceLine.linePtr)));
            for (SubLine subline : sourceLine.sublines) {
                String token = this.getDisplayToken(this.buffer[subline.startPtr]);
                String formattedHex = HexFormatter.formatNoHeader(this.buffer, subline.startPtr, subline.length, loadAddress + subline.startPtr);
                String[] stringArray = formattedHex.split("\n");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String bytes = stringArray[n2];
                    text.append(String.format("        %-8s %s%n", token, bytes));
                    token = "";
                    ++n2;
                }
            }
            text.append("\n");
        }
        if (this.endPtr < this.buffer.length) {
            int length = this.buffer.length - this.endPtr;
            int ptr = this.endPtr;
            if (length >= 2) {
                text.append("                 ");
                text.append(HexFormatter.formatNoHeader(this.buffer, this.endPtr, 2, loadAddress + ptr));
                text.append("\n\n");
                ptr += 2;
                length -= 2;
            }
            if (length > 0) {
                String formattedHex = HexFormatter.formatNoHeader(this.buffer, ptr, this.buffer.length - ptr, loadAddress + ptr);
                String[] stringArray = formattedHex.split("\n");
                int n = stringArray.length;
                int n3 = 0;
                while (n3 < n) {
                    String bytes = stringArray[n3];
                    text.append(String.format("                 %s%n", bytes));
                    ++n3;
                }
            }
            if (length > 1) {
                byte[] extraBuffer = new byte[length];
                System.arraycopy(this.buffer, ptr, extraBuffer, 0, extraBuffer.length);
                AssemblerProgram assemblerProgram = new AssemblerProgram("extra", extraBuffer, loadAddress + ptr);
                text.append("\n");
                text.append(assemblerProgram.getText());
            }
        }
    }

    private String getDisplayToken(byte b) {
        if (Utility.isHighBitSet(b)) {
            return ApplesoftConstants.tokens[b & 0x7F];
        }
        if (Utility.isDigit(b) || Utility.isLetter(b) || b == 58 || b == 0) {
            return "";
        }
        return "*******";
    }
}

