/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.CharacterList;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.awt.image.DataBuffer;

public class CharacterRom
extends CharacterList {
    private static final int charsX = 16;
    private static final int HEADER_LENGTH = 256;
    String description;

    public CharacterRom(String name, byte[] buffer) {
        super(name, buffer);
        this.description = HexFormatter.getCString(buffer, 16);
        int ptr = 256;
        while (ptr < buffer.length) {
            this.characters.add(new CharacterRomCharacter(buffer, ptr));
            ptr += 8;
        }
        this.buildImage(3, 3, 3, 3, 7, 8, 16);
    }

    public static boolean isRom(byte[] buffer) {
        if (buffer.length != 1024) {
            return false;
        }
        return buffer[0] == -67 && buffer[1] == 65 && buffer[2] == 83 && buffer[4] == -96 && buffer[5] == 7 && buffer[6] == 8;
    }

    class CharacterRomCharacter
    extends CharacterList.Character {
        public CharacterRomCharacter(byte[] buffer, int ptr) {
            super(7, 8);
            DataBuffer dataBuffer = this.image.getRaster().getDataBuffer();
            int element = 0;
            int i = 0;
            while (i < 8) {
                int value = buffer[ptr++] & 0xFF;
                int j = 0;
                while (j < 7) {
                    dataBuffer.setElem(element++, (value & 0x80) == 0 ? 0 : 255);
                    value <<= 1;
                    ++j;
                }
                ++i;
            }
        }
    }
}

