/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.BasicProgram;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import com.bytezone.diskbrowser.utilities.Utility;

public class CPMBasicFile
extends BasicProgram {
    String[] tokens = new String[]{"", "END", "FOR", "NEXT", "DATA", "INPUT", "DIM", "READ", "LET", "GOTO", "RUN", "IF", "RESTORE", "GOSUB", "RETURN", "REM", "STOP", "PRINT", "CLEAR", "LIST", "NEW", "ON", "DEF", "POKE", "", "", "", "LPRINT", "LLIST", "WIDTH", "ELSE", "", "", "SWAP", "ERASE", "", "ERROR", "RESUME", "DELETE", "", "RENUM", "DEFSTR", "DEFINT", "", "DEFDBL", "LINE", "", "WHILE", "WEND", "CALL", "WRITE", "COMMON", "CHAIN", "OPTION", "RANDOMIZE", "SYSTEM", "OPEN", "FIELD", "GET", "PUT", "CLOSE", "LOAD", "MERGE", "", "NAME", "KILL", "LSET", "RSET", "SAVE", "RESET", "TEXT", "HOME", "VTAB", "HTAB", "INVERSE", "NORMAL", "", "", "", "", "", "", "", "", "", "WAIT", "", "", "", "", "", "", "", "TO", "THEN", "TAB(", "STEP", "USR", "FN", "SPC(", "", "ERL", "ERR", "STRING$", "USING", "INSTR", "'", "VARPTR", "", "", "INKEY$", ">", "=", "<", "+", "-", "*", "/", "", "AND", "OR", "", "", "", "MOD", "/", "", ""};
    String[] functions = new String[]{"", "LEFT$", "RIGHT$", "MID$", "SGN", "INT", "ABS", "SQR", "RND", "SIN", "LOG", "EXP", "COS", "TAN", "ATN", "FRE", "POS", "LEN", "STR$", "VAL", "ASC", "CHR$", "PEEK", "SPACE$", "OCT$", "HEX$", "LPOS", "CINT", "CSNG", "CDBL", "FIX", "", "", "", "", "", "", "", "", "", "", "", "CVI", "CVS", "CVD", "", "EOF", "LOC", "", "MKI$", "MKS$", "MKD$"};

    public CPMBasicFile(String name, byte[] buffer) {
        super(name, buffer);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        if (CPMBasicFile.basicPreferences.showHeader) {
            text.append("Name : " + this.name + "\n\n");
        }
        int ptr = 5;
        while (this.buffer[ptr] != 0) {
            ++ptr;
        }
        if (showDebugText) {
            return this.debugText();
        }
        ptr = 1;
        while (ptr < this.buffer.length) {
            int val;
            int nextAddress = Utility.getShort(this.buffer, ptr);
            if (nextAddress == 0) break;
            int lineNumber = Utility.getShort(this.buffer, ptr + 2);
            text.append(String.format(" %d ", lineNumber));
            ptr += 4;
            block13: while ((val = this.buffer[ptr++] & 0xFF) != 0) {
                if ((val & 0x80) != 0) {
                    String token;
                    if (val == 255) {
                        if ((token = this.functions[(val = this.buffer[ptr++] & 0xFF) & 0x7F]).length() == 0) {
                            token = String.format("<FF %02X>", val);
                        }
                        text.append(token);
                        continue;
                    }
                    token = this.tokens[val & 0x7F];
                    if (token.length() == 0) {
                        token = String.format("<%02X>", val);
                    }
                    text.append(token);
                    continue;
                }
                if (val >= 32 && val <= 126) {
                    if (val == 58 && ptr + 1 < this.buffer.length && this.buffer[ptr] == -113 && this.buffer[ptr + 1] == -22) {
                        text.append("'");
                        ptr += 2;
                        continue;
                    }
                    if (val == 58 && ptr < this.buffer.length && this.buffer[ptr] == -98) continue;
                    text.append(String.format("%s", Character.valueOf((char)val)));
                    continue;
                }
                if (val >= 17 && val <= 26) {
                    text.append(val - 17);
                    continue;
                }
                switch (val) {
                    case 7: {
                        text.append("<BELL>");
                        continue block13;
                    }
                    case 9: {
                        text.append("        ");
                        continue block13;
                    }
                    case 10: {
                        text.append("\n ");
                        continue block13;
                    }
                    case 12: {
                        text.append("&H" + String.format("%X", Utility.getShort(this.buffer, ptr)));
                        ptr += 2;
                        continue block13;
                    }
                    case 14: {
                        text.append(Utility.getShort(this.buffer, ptr));
                        ptr += 2;
                        continue block13;
                    }
                    case 15: {
                        text.append(this.buffer[ptr++] & 0xFF);
                        continue block13;
                    }
                    case 28: {
                        text.append(Utility.getShort(this.buffer, ptr));
                        ptr += 2;
                        continue block13;
                    }
                    case 29: {
                        String d4 = String.valueOf(Utility.floatValueMS4(this.buffer, ptr));
                        if (d4.endsWith(".0")) {
                            d4 = d4.substring(0, d4.length() - 2);
                        }
                        text.append(String.valueOf(d4) + "!");
                        ptr += 4;
                        continue block13;
                    }
                    case 31: {
                        String d8 = String.valueOf(Utility.floatValueMS8(this.buffer, ptr));
                        if (d8.endsWith(".0")) {
                            d8 = d8.substring(0, d8.length() - 2);
                        }
                        text.append(String.valueOf(d8) + "#");
                        ptr += 8;
                        continue block13;
                    }
                }
                text.append(String.format("<%02X>", val));
            }
            text.append("\n");
        }
        return Utility.rtrim(text);
    }

    private String debugText() {
        StringBuilder text = new StringBuilder();
        int ptr = 1;
        while (ptr < this.buffer.length) {
            byte val;
            int nextAddress = Utility.getShort(this.buffer, ptr);
            if (nextAddress == 0) break;
            int lineNumber = Utility.getShort(this.buffer, ptr + 2);
            int lastPtr = ptr;
            ptr += 4;
            while ((val = this.buffer[ptr++]) != 0) {
                ptr += (switch (val) {
                    case 12, 14, 28 -> 2;
                    case 29 -> 4;
                    case 31 -> 8;
                    case 15, 255 -> 1;
                    default -> 0;
                });
            }
            text.append(String.format(" %d  %s%n", lineNumber, HexFormatter.getHexString(this.buffer, lastPtr + 4, ptr - lastPtr - 4)));
        }
        return Utility.rtrim(text);
    }
}

