/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.utilities.HexFormatter;

public class BootSector
extends AbstractSector {
    private static final byte[] skew;
    private static final int SKEW_OFFSET = 77;
    private static final int SKEW_OFFSET_2 = 60;
    AssemblerProgram assembler1;
    AssemblerProgram assembler2;
    String name;

    static {
        byte[] byArray = new byte[16];
        byArray[1] = 13;
        byArray[2] = 11;
        byArray[3] = 9;
        byArray[4] = 7;
        byArray[5] = 5;
        byArray[6] = 3;
        byArray[7] = 1;
        byArray[8] = 14;
        byArray[9] = 12;
        byArray[10] = 10;
        byArray[11] = 8;
        byArray[12] = 6;
        byArray[13] = 4;
        byArray[14] = 2;
        byArray[15] = 15;
        skew = byArray;
    }

    public BootSector(Disk disk, byte[] buffer, String name, DiskAddress diskAddress) {
        super(disk, buffer, diskAddress);
        this.name = name;
    }

    public BootSector(Disk disk, byte[] buffer, String name) {
        super(disk, buffer);
        this.name = name;
    }

    @Override
    public String createText() {
        StringBuilder text = new StringBuilder();
        if (this.assembler1 == null) {
            int flag = this.buffer[0] & 0xFF;
            if (flag == 1) {
                if (this.matches(this.buffer, 77, skew)) {
                    int newLen = 256 - (77 + skew.length);
                    byte[] buf1 = new byte[77];
                    byte[] buf2 = new byte[newLen];
                    System.arraycopy(this.buffer, 0, buf1, 0, 77);
                    System.arraycopy(this.buffer, 77 + skew.length, buf2, 0, newLen);
                    this.assembler1 = new AssemblerProgram(String.valueOf(this.name) + " (first)", buf1, 2048, 1);
                    this.assembler2 = new AssemblerProgram(String.valueOf(this.name) + " (second)", buf2, 77 + skew.length, 0);
                } else {
                    this.assembler1 = new AssemblerProgram(String.valueOf(this.name) + " Boot Loader", this.buffer, 0, 1);
                }
            } else {
                this.assembler1 = new AssemblerProgram(String.valueOf(this.name) + " Boot Loader", this.buffer, 0, 0);
            }
        }
        text.append(this.assembler1.getText());
        if (this.assembler2 != null) {
            text.append("\n\n");
            text.append(HexFormatter.formatNoHeader(this.buffer, 77, skew.length, 2125));
            text.append("\n\n");
            text.append(this.assembler2.getText());
        }
        return text.toString();
    }

    private boolean matches(byte[] buffer, int offset, byte[] test) {
        if (test.length == 0 || test.length > buffer.length - offset) {
            return false;
        }
        int i = 0;
        while (i < test.length) {
            if (test[i] != buffer[offset++]) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

