/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.BasicProgram;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class BasicProgramGS
extends BasicProgram {
    private static String[] tokens = new String[]{"AUTO", "DEL", "EDI", "HLIST ", "LIST", "RENUM", "BREAK ", "FN ", "PROC ", "GOSUB", " GOTO ", "FOR ", " THEN ", "ELSE ", "NEXT ", "OFF ", "ON ", "INPUT ", "OUTPUT ", "TEXT ", "TIMER ", "EXCEPTION ", "CAT ", " 97 ", "INIT ", "INVOKE ", "LIBRARY ", "PREFIX ", "TYPE ", "LOAD ", "SAVE ", "DELETE ", "RUN ", "RENAME ", "CREATE ", "LOCK ", "UNLOCK ", "EXEC ", "CHAIN ", "CATALOG ", "OPEN ", "QUIT ", "DIR ", "DIM ", "READ ", "WRITE ", "CLOSE ", "TASKPOLL ", "LOCATE ", "EVENTDEF ", "MENUDEF ", "VOLUMES ", "CALL% ", "CALL ", "_", "TEXTPORT ", "PERFORM ", "GRAF ", "DBUG ", "POP ", "HOME ", "SUB$(", "TRACE ", "NOTRACE ", "NORMAL ", "INVERSE ", "RESUME ", "LET ", "IF ", "RESTORE ", "SWAP ", "RETURN ", "REM ", "STOP ", "DATA ", "IMAGE ", "LIBFIND ", "DEF ", "PRINT ", "CLEAR ", "RANDOMIZE ", "NEW ", "POKE ", "ASSIGN ", "GET ", "PUT ", "SET ", "ERROR ", "ERASE ", "LOCAL ", "WHILE ", "CONT ", "DO ", "UNTIL ", "END ", " DF ", " E0 ", " E1 ", " E2 ", " E3 ", " E4 ", " E5 ", " E6 ", " E7 ", " E8 ", " E9 ", " EA ", " EB ", " EC ", " ED ", " EE ", " EF  ", " F0 ", " F1 ", " F2 ", " F3 ", " F4 ", " F5 ", " F6 ", " F7 ", " F8 ", " F9 ", " FA ", " FB ", " FC ", " FD ", " FE ", " FF  "};
    private static String[] tokensDF = new String[]{" TAB(", " TO ", " SPC(", " USING ", "APPEND ", " MOD ", " REMDR ", " STEP ", " AND ", " OR ", " XOR ", " DIV ", " SRC ", " NOT ", " 8E ", " UPDATE ", " TXT ", " BDF ", " FILTYPE= ", " AS ", " 94 ", " 95 ", " SGN(", " INT ", " ABS(", " TYP(", " REC(", " JOYX(", " PDL(", " BTN(", " R.STACK% ", " R.STACK@ ", " R.STACK&(", " SQR(", " RND(", " LOG(", " LOG1(", " LOG2(", " LOGB%(", " EXP(", " EXP1(", " EXP2(", " COS(", " SIN(", " TAN(", " ATN(", " BASIC@(", " DATE(", " EOFMARK(", " FILTYP(", " FIX(", " FREMEM(", " NEGATE(", " PEEK(", " ROUND(", " TASKREC%(", " TASKREC@(", " TIME(", " UIR(", " STR$(", " HEX$(", " PFX$(", " SPACE$(", " ERRTXT$(", " CHR$(", " RELATION(", " ANU(", " COMPI(", " SCALB(", " SCALE(", " LEN(", " VAL(", " ASC(", " UCASE$(", "TEN(", " CONV#(", " CONV@(", " CONV(", " CONV&(", " CONV$", " CONV%(", " LEFT$(", " RIGHT$(", " REP$(", " MID$(", " INSTR(", "VARPTR(", "VARPTR$(", "VAR$(", "VAR(", " UBOUND(", " FILE(", " EXEVENT@(", " DD ", " DE ", " DF ", " HPOS ", " VPOS ", " TIME$ ", " DATE$ ", " PREFIX$ ", " E5 ", " OUTREC ", " INDENT ", " SHOWDIGITS ", " LISTTAB ", " AUXID@ ", " EXFN ", " SECONDS@ ", " FRE ", " ERRLIN ", "ERR ", " KBD ", " EOF ", " JOYY ", " PDL9 ", " PI ", " ERRTOOL ", " F6 ", " F7 ", " F8 ", " F9 ", " FA ", " FB ", " FC ", " FD ", " FE ", " FF "};
    private final List<SourceLine> sourceLines = new ArrayList<SourceLine>();

    public BasicProgramGS(String name, byte[] buffer) {
        super(name, buffer);
        int ptr = 5;
        while (ptr < buffer.length) {
            SourceLine sourceLine = new SourceLine(ptr);
            if (sourceLine.lineNumber == 0) break;
            this.sourceLines.add(sourceLine);
            ptr += sourceLine.length;
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        for (SourceLine sourceLine : this.sourceLines) {
            text.append(sourceLine + "\n");
        }
        return text.toString();
    }

    private class SourceLine {
        int lineNumber;
        int length;
        String label;
        String line;

        public SourceLine(int ptr) {
            int labelLength = BasicProgramGS.this.buffer[ptr] & 0xFF;
            this.label = labelLength > 1 ? new String(BasicProgramGS.this.buffer, ptr + 1, labelLength - 1) : "";
            int lineLength = BasicProgramGS.this.buffer[ptr += labelLength] & 0xFF;
            this.lineNumber = Utility.getShort(BasicProgramGS.this.buffer, ptr + 1);
            this.length = labelLength + lineLength;
            if (this.lineNumber == 0) {
                return;
            }
            int max = (ptr += 3) + lineLength - 4;
            StringBuilder text = new StringBuilder();
            while (ptr < max) {
                byte b1;
                if (Utility.isHighBitSet(b1 = BasicProgramGS.this.buffer[ptr++])) {
                    ptr = this.tokenOrNumber(b1, text, ptr);
                    continue;
                }
                text.append((char)((b1 & 0xFF) < 32 ? 46 : (char)b1));
            }
            this.line = text.toString();
        }

        private int tokenOrNumber(byte b1, StringBuilder text, int ptr) {
            if (b1 == -33) {
                this.append(tokensDF[BasicProgramGS.this.buffer[ptr++] & 0x7F], text);
                return ptr;
            }
            if (b1 < -32) {
                this.append(tokens[b1 & 0x7F], text);
                return ptr;
            }
            if (b1 == -4) {
                text.append(this.get(ptr, 3));
                return ptr + 4;
            }
            if (b1 == -6) {
                text.append(this.get(ptr, 2));
                return ptr + 2;
            }
            if (b1 == -5) {
                return ptr + 3;
            }
            if ((b1 & 0xF0) == 240) {
                text.append(b1 & 0xF);
                return ptr;
            }
            if ((b1 & 0xE0) == 224) {
                text.append((b1 & 0xF) << 8 | BasicProgramGS.this.buffer[ptr++] & 0xFF);
                return ptr;
            }
            System.out.printf("not handled: %02X%n", b1);
            return ptr;
        }

        private void append(String word, StringBuilder text) {
            if (word.startsWith(" ") && text.length() > 0 && text.charAt(text.length() - 1) == ' ') {
                text.deleteCharAt(text.length() - 1);
            }
            text.append(word);
        }

        private int get(int ptr, int size) {
            int val = 0;
            int i = 0;
            while (i < size) {
                val |= (BasicProgramGS.this.buffer[ptr++] & 0xFF) << i * 8;
                ++i;
            }
            return val;
        }

        private void show(int ptr, int size) {
            int i = 0;
            while (i < size) {
                System.out.printf(" %02X ", BasicProgramGS.this.buffer[ptr++]);
                ++i;
            }
            System.out.println();
        }

        public String toString() {
            return String.format("%5d %-12s %s", this.lineNumber, this.label, this.line);
        }
    }
}

