/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.AssemblerStatement;
import com.bytezone.diskbrowser.gui.AssemblerPreferences;
import com.bytezone.diskbrowser.gui.DiskBrowser;
import com.bytezone.diskbrowser.utilities.HexFormatter;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssemblerProgram
extends AbstractFile {
    static AssemblerPreferences assemblerPreferences;
    private static Map<Integer, String> equates;
    private final int loadAddress;
    private int executeOffset;
    private byte[] extraBuffer = new byte[0];
    private List<Integer> entryPoints;
    private List<StringLocation> stringLocations;

    public static void setAssemblerPreferences(AssemblerPreferences assemblerPreferences) {
        AssemblerProgram.assemblerPreferences = assemblerPreferences;
    }

    public AssemblerProgram(String name, byte[] buffer, int address) {
        super(name, buffer);
        this.loadAddress = address;
        if (equates == null) {
            this.getEquates();
        }
    }

    public AssemblerProgram(String name, byte[] buffer, int address, int executeOffset) {
        this(name, buffer, address);
        this.executeOffset = executeOffset;
    }

    public void setExtraBuffer(byte[] fullBuffer, int offset, int length) {
        if (length >= 0) {
            this.extraBuffer = new byte[length];
            System.arraycopy(fullBuffer, offset, this.extraBuffer, 0, length);
        } else {
            System.out.println("Invalid length in setExtraBuffer() : " + length);
        }
    }

    @Override
    public String getHexDump() {
        String text = HexFormatter.format(this.buffer, 0, this.buffer.length, this.loadAddress);
        if (this.extraBuffer.length == 0) {
            return text;
        }
        return String.valueOf(text) + "\n\nData outside actual buffer:\n\n" + HexFormatter.format(this.extraBuffer, 0, this.extraBuffer.length, this.loadAddress + this.buffer.length);
    }

    @Override
    public String getAssembler() {
        if (this.buffer == null) {
            return "No buffer";
        }
        if (this.assembler == null) {
            this.assembler = new AssemblerProgram(this.name, this.buffer, this.loadAddress);
        }
        if (this.extraBuffer.length == 0) {
            return this.assembler.getText();
        }
        String extraName = String.format("%s (extra)", this.name);
        AssemblerProgram assemblerProgram = new AssemblerProgram(extraName, this.extraBuffer, this.loadAddress + this.buffer.length);
        return String.valueOf(this.assembler.getText()) + "\n\n" + assemblerProgram.getText();
    }

    private void addHeader(StringBuilder pgm) {
        pgm.append(String.format("Name    : %s%n", this.name));
        pgm.append(String.format("Length  : $%04X (%,d)%n", this.buffer.length, this.buffer.length));
        pgm.append(String.format("Load at : $%04X (%,d)%n", this.loadAddress, this.loadAddress));
        if (this.executeOffset > 0) {
            pgm.append(String.format("Entry   : $%04X%n", this.loadAddress + this.executeOffset));
        }
        pgm.append("\n");
    }

    @Override
    public String getText() {
        StringBuilder pgm = new StringBuilder();
        if (AssemblerProgram.assemblerPreferences.showHeader) {
            this.addHeader(pgm);
        }
        pgm.append(this.getListing());
        if (AssemblerProgram.assemblerPreferences.showStrings) {
            pgm.append(this.getStringsText());
        }
        return pgm.toString();
    }

    private String getListing() {
        StringBuilder pgm = new StringBuilder();
        List<AssemblerStatement> lines = this.getLines();
        if (this.stringLocations == null) {
            this.getStrings();
        }
        int i = 0;
        while (i < this.executeOffset) {
            pgm.append(String.format("    %04X: %02X%n", this.loadAddress + i, this.buffer[i]));
            ++i;
        }
        for (AssemblerStatement cmd : lines) {
            StringBuilder line = new StringBuilder();
            String arrowText = AssemblerProgram.assemblerPreferences.showTargets ? this.getArrow(cmd) : "";
            line.append(String.format("%3.3s %04X: %02X ", arrowText, cmd.address, cmd.value));
            if (cmd.size > 1) {
                line.append(String.format("%02X ", cmd.operand1));
            }
            if (cmd.size > 2) {
                line.append(String.format("%02X ", cmd.operand2));
            }
            while (line.length() < 23) {
                line.append(" ");
            }
            line.append(String.valueOf(cmd.mnemonic) + " " + cmd.operand);
            if (cmd.offset != 0) {
                int branch = cmd.address + cmd.offset + 2;
                line.append(String.format("$%04X", branch < 0 ? (branch = branch + 65535) : branch));
            } else if (cmd.target > 0 && (cmd.target < this.loadAddress - 1 || cmd.target > this.loadAddress + this.buffer.length)) {
                while (line.length() < 40) {
                    line.append(" ");
                }
                String text = equates.get(cmd.target);
                if (text != null) {
                    line.append("; " + text);
                } else {
                    int i2 = 0;
                    int max = ApplesoftConstants.tokenAddresses.length;
                    while (i2 < max) {
                        if (cmd.target == ApplesoftConstants.tokenAddresses[i2]) {
                            line.append("; Applesoft - " + ApplesoftConstants.tokens[i2]);
                            break;
                        }
                        ++i2;
                    }
                }
            }
            pgm.append(String.valueOf(line.toString()) + "\n");
        }
        if (pgm.length() > 0) {
            pgm.deleteCharAt(pgm.length() - 1);
        }
        return pgm.toString();
    }

    private List<AssemblerStatement> getLines() {
        ArrayList<AssemblerStatement> lines = new ArrayList<AssemblerStatement>();
        HashMap<Integer, AssemblerStatement> linesMap = new HashMap<Integer, AssemblerStatement>();
        ArrayList<Integer> targets = new ArrayList<Integer>();
        int ptr = this.executeOffset;
        int address = this.loadAddress + this.executeOffset;
        while (ptr < this.buffer.length) {
            AssemblerStatement cmd = new AssemblerStatement(this.buffer[ptr]);
            lines.add(cmd);
            linesMap.put(address, cmd);
            cmd.address = address;
            if (cmd.size == 2 && ptr < this.buffer.length - 1) {
                cmd.addData(this.buffer[ptr + 1]);
            } else if (cmd.size == 3 && ptr < this.buffer.length - 2) {
                cmd.addData(this.buffer[ptr + 1], this.buffer[ptr + 2]);
            } else {
                cmd.size = 1;
            }
            if (cmd.target >= this.loadAddress && cmd.target < this.loadAddress + this.buffer.length && (cmd.value == 76 || cmd.value == 108 || cmd.value == 32)) {
                targets.add(cmd.target);
            }
            if (cmd.offset != 0) {
                targets.add(cmd.address + cmd.offset + 2);
            }
            address += cmd.size;
            ptr += cmd.size;
        }
        for (Integer target : targets) {
            AssemblerStatement cmd = (AssemblerStatement)linesMap.get(target);
            if (cmd == null) continue;
            cmd.isTarget = true;
        }
        return lines;
    }

    private String getStringsText() {
        if (this.stringLocations.size() == 0) {
            return "";
        }
        StringBuilder text = new StringBuilder("\n\nPossible strings:\n\n");
        for (StringLocation stringLocation : this.stringLocations) {
            int address = stringLocation.offset + this.loadAddress;
            text.append(String.format("%s %04X - %04X  %s %n", this.entryPoints.contains(stringLocation.offset) ? "*" : " ", address, address + stringLocation.length, stringLocation));
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private void getStrings() {
        this.entryPoints = new ArrayList<Integer>();
        this.stringLocations = new ArrayList<StringLocation>();
        int start = 0;
        int ptr = 0;
        while (ptr < this.buffer.length) {
            if ((this.buffer[ptr] & 0x80) == 0 && this.buffer[ptr] != 13) {
                if (ptr - start > 3) {
                    this.stringLocations.add(new StringLocation(start, ptr - 1));
                }
                start = ptr + 1;
            }
            ++ptr;
        }
        if (this.buffer.length - start > 3) {
            this.stringLocations.add(new StringLocation(start, this.buffer.length - 1));
        }
        int max = this.buffer.length - 2;
        block1: for (StringLocation stringLocation : this.stringLocations) {
            int ptr2 = 0;
            while (ptr2 < max) {
                if (stringLocation.matches(this.buffer, ptr2)) {
                    this.entryPoints.add(stringLocation.offset);
                    continue block1;
                }
                ++ptr2;
            }
        }
    }

    private String getArrow(AssemblerStatement cmd) {
        String arrow = "";
        if (cmd.value == 76 || cmd.value == 108 || cmd.value == 96 || cmd.offset != 0) {
            arrow = "<--";
        }
        if (cmd.value == 32 && this.isLocal(cmd.target)) {
            arrow = "<--";
        }
        if (cmd.isTarget) {
            arrow = arrow.isEmpty() ? "-->" : "<->";
        }
        return arrow;
    }

    private boolean isLocal(int target) {
        return target >= this.loadAddress && target < this.loadAddress + this.buffer.length + this.extraBuffer.length;
    }

    private void getEquates() {
        equates = new HashMap<Integer, String>();
        DataInputStream inputEquates = new DataInputStream(DiskBrowser.class.getClassLoader().getResourceAsStream("com/bytezone/diskbrowser/applefile/equates.txt"));
        BufferedReader in = new BufferedReader(new InputStreamReader(inputEquates));
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if (line.isEmpty() || line.startsWith("*")) continue;
                int address = Integer.parseInt(line.substring(0, 4), 16);
                if (equates.containsKey(address)) {
                    System.out.printf("Duplicate equate entry : %04X%n" + address, new Object[0]);
                    continue;
                }
                equates.put(address, line.substring(6));
            }
            in.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    class StringLocation {
        int offset;
        byte hi;
        byte lo;
        int length;
        boolean zeroTerminated;
        boolean lowTerminated;
        boolean hasLengthByte;
        int digits;
        int letters;
        int punctuation;
        int controlChars;
        int spaces;

        public StringLocation(int first, int last) {
            this.offset = first;
            this.length = last - this.offset + 1;
            int end = last + 1;
            this.zeroTerminated = end < AssemblerProgram.this.buffer.length && AssemblerProgram.this.buffer[end] == 0;
            boolean bl = this.lowTerminated = end < AssemblerProgram.this.buffer.length && AssemblerProgram.this.buffer[end] >= 32 && AssemblerProgram.this.buffer[end] < 127;
            if (first > 0 && (AssemblerProgram.this.buffer[first] & 0xFF) == this.length + 1) {
                this.hasLengthByte = true;
                --this.offset;
                ++this.length;
            }
            this.hi = (byte)(this.offset + AssemblerProgram.this.loadAddress >>> 8);
            this.lo = (byte)(this.offset + AssemblerProgram.this.loadAddress & 0xFF);
            int i = this.offset;
            while (i < this.offset + this.length) {
                int val = AssemblerProgram.this.buffer[i] & 0x7F;
                if (val < 32 || val == 127) {
                    ++this.controlChars;
                } else if (val == 32) {
                    ++this.spaces;
                } else if (val >= 48 && val <= 57) {
                    ++this.digits;
                } else if (val >= 65 && val <= 90) {
                    ++this.letters;
                } else if (val >= 97 && val <= 122) {
                    ++this.letters;
                } else {
                    ++this.punctuation;
                }
                ++i;
            }
        }

        boolean matches(byte[] buffer, int ptr) {
            return this.lo == buffer[ptr] && this.hi == buffer[ptr + 1];
        }

        boolean likelyString() {
            return this.spaces > 0 || this.letters > this.punctuation;
        }

        public String address() {
            return String.format("%04X  %02X %02X", this.offset, this.hi, this.lo);
        }

        public String toStatisticsString() {
            return String.format("%2d, %2d, %2d, %2d, %2d", this.digits, this.letters, this.punctuation, this.controlChars, this.spaces);
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            if (this.hasLengthByte) {
                text.append("<length>");
            }
            int i = this.offset;
            while (i < this.offset + this.length) {
                int val = AssemblerProgram.this.buffer[i] & 0x7F;
                if (val == 4) {
                    text.append("<ctrl-D>");
                } else if (val == 10) {
                    text.append("<LF>");
                } else if (val == 13) {
                    text.append("<CR>");
                } else {
                    text.append((char)val);
                }
                ++i;
            }
            if (this.lowTerminated) {
                text.append((char)AssemblerProgram.this.buffer[this.offset + this.length]);
            }
            return text.toString();
        }
    }
}

