/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AssemblerStatement;
import java.util.ArrayList;
import java.util.Iterator;

public class AssemblerBlocks {
    public AssemblerBlocks(byte[] buffer, int loadAddress) {
        int ptr = 0;
        boolean inCode = true;
        int address = loadAddress;
        ArrayList<Integer> loadTargets = new ArrayList<Integer>();
        ArrayList<Integer> branchTargets = new ArrayList<Integer>();
        while (ptr < buffer.length) {
            if (branchTargets.contains(address)) {
                inCode = true;
            }
            if (inCode) {
                AssemblerStatement cmd = new AssemblerStatement(buffer[ptr]);
                if (cmd.size == 2 && ptr < buffer.length - 1) {
                    cmd.addData(buffer[ptr + 1]);
                } else if (cmd.size == 3 && ptr < buffer.length - 2) {
                    cmd.addData(buffer[ptr + 1], buffer[ptr + 2]);
                } else {
                    cmd.size = 1;
                }
                cmd.address = address;
                if (branchTargets.contains(address)) {
                    System.out.print("> ");
                } else {
                    System.out.print("  ");
                }
                System.out.printf("%s%n", cmd);
                ptr += cmd.size;
                address += cmd.size;
                if (cmd.opcode == 96 || cmd.opcode == 76) {
                    inCode = false;
                }
                if (cmd.opcode == 76 || cmd.opcode == 108 || cmd.opcode == 32) {
                    branchTargets.add(cmd.target);
                }
                if (cmd.opcode == 185) {
                    int target = (cmd.operand2 & 0xFF) << 8 | cmd.operand1 & 0xFF;
                    loadTargets.add(target);
                }
                if (cmd.offset == 0) continue;
                branchTargets.add(cmd.address + cmd.offset + 2);
                continue;
            }
            if (loadTargets.contains(address)) {
                System.out.print("* ");
            } else {
                System.out.print("  ");
            }
            System.out.printf("%06X  %02X  %s%n", address, buffer[ptr], Character.valueOf((char)(buffer[ptr] & 0x7F)));
            ++ptr;
            ++address;
        }
        Iterator iterator = loadTargets.iterator();
        while (iterator.hasNext()) {
            int loadTarget = (Integer)iterator.next();
            System.out.printf("load  : $%04X%n", loadTarget);
        }
        iterator = branchTargets.iterator();
        while (iterator.hasNext()) {
            int branchTarget = (Integer)iterator.next();
            System.out.printf("branch: $%04X%n", branchTarget);
        }
    }
}

