/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.applefile;

import com.bytezone.diskbrowser.applefile.AppleBasicFormatter;
import com.bytezone.diskbrowser.applefile.ApplesoftConstants;
import com.bytezone.diskbrowser.applefile.BasicProgram;
import com.bytezone.diskbrowser.applefile.DebugBasicFormatter;
import com.bytezone.diskbrowser.applefile.HeaderFormatter;
import com.bytezone.diskbrowser.applefile.SourceLine;
import com.bytezone.diskbrowser.applefile.UserBasicFormatter;
import com.bytezone.diskbrowser.applefile.XrefFormatter;
import com.bytezone.diskbrowser.utilities.Utility;
import java.util.ArrayList;
import java.util.List;

public class ApplesoftBasicProgram
extends BasicProgram
implements ApplesoftConstants {
    private final List<SourceLine> sourceLines = new ArrayList<SourceLine>();
    private int ptr;
    private final UserBasicFormatter userBasicFormatter;
    private final AppleBasicFormatter appleBasicFormatter;
    private final DebugBasicFormatter debugBasicFormatter;
    private final XrefFormatter xrefFormatter;
    private final HeaderFormatter headerFormatter;

    public ApplesoftBasicProgram(String name, byte[] buffer) {
        super(name, buffer);
        while (buffer[this.ptr + 1] != 0) {
            SourceLine line = new SourceLine(this, buffer, this.ptr);
            this.sourceLines.add(line);
            this.ptr += line.length;
        }
        this.userBasicFormatter = new UserBasicFormatter(this, basicPreferences);
        this.appleBasicFormatter = new AppleBasicFormatter(this, basicPreferences);
        this.debugBasicFormatter = new DebugBasicFormatter(this, basicPreferences);
        this.xrefFormatter = new XrefFormatter(this, basicPreferences);
        this.headerFormatter = new HeaderFormatter(this, basicPreferences);
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        if (ApplesoftBasicProgram.basicPreferences.showHeader) {
            this.headerFormatter.append(text);
        }
        if (showDebugText) {
            this.debugBasicFormatter.append(text);
            return Utility.rtrim(text);
        }
        if (this.sourceLines.size() == 0) {
            text.append("\n\nThis page intentionally left blank");
            return text.toString();
        }
        if (ApplesoftBasicProgram.basicPreferences.userFormat) {
            this.userBasicFormatter.append(text);
        } else {
            this.appleBasicFormatter.append(text);
        }
        if (ApplesoftBasicProgram.basicPreferences.showAllXref) {
            this.xrefFormatter.append(text);
        }
        return Utility.rtrim(text);
    }

    List<SourceLine> getSourceLines() {
        return this.sourceLines;
    }

    int getEndPtr() {
        return this.ptr;
    }
}

