/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import java.util.ArrayList;
import java.util.List;

abstract class Message
extends AbstractFile {
    private static int nextId = 0;
    protected String message;
    private final int id;
    private int totalLines;
    List<String> lines = new ArrayList<String>();

    public Message(byte[] buffer) {
        super("Message " + nextId, buffer);
        this.id = nextId;
        int recordLength = 42;
        StringBuilder text = new StringBuilder();
        int ptr = 0;
        while (ptr < buffer.length) {
            ++nextId;
            ++this.totalLines;
            String line = this.getLine(ptr);
            text.append(String.valueOf(line) + "\n");
            this.lines.add(line);
            ptr += recordLength;
        }
        text.deleteCharAt(text.length() - 1);
        this.message = text.toString();
    }

    protected abstract String getLine(int var1);

    public boolean match(int messageNum) {
        if (this.id == messageNum) {
            return true;
        }
        return messageNum > this.id && messageNum < this.id + this.totalLines;
    }

    @Override
    public String getText() {
        return this.message;
    }

    public String toHTMLString() {
        StringBuilder message = new StringBuilder();
        for (String line : this.lines) {
            message.append("&nbsp;" + line + "&nbsp;<br>");
        }
        if (message.length() > 0) {
            int i = 0;
            while (i < 4) {
                message.deleteCharAt(message.length() - 1);
                ++i;
            }
        }
        return message.toString();
    }

    public static void resetMessageId() {
        nextId = 0;
    }
}

