/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.wizardry;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.wizardry.Item;
import com.bytezone.diskbrowser.wizardry.MazeAddress;
import com.bytezone.diskbrowser.wizardry.MazeCell;
import com.bytezone.diskbrowser.wizardry.Message;
import com.bytezone.diskbrowser.wizardry.Monster;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.List;

class MazeLevel
extends AbstractFile {
    public int level;
    private List<Message> messages;
    private List<Monster> monsters;
    private List<Item> items;

    public MazeLevel(byte[] buffer, int level) {
        super("Level " + level, buffer);
        this.level = level;
    }

    @Override
    public BufferedImage getImage() {
        Dimension cellSize = new Dimension(22, 22);
        this.image = new BufferedImage(20 * cellSize.width + 1, 20 * cellSize.height + 1, 9);
        Graphics2D g = this.image.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int row = 0;
        while (row < 20) {
            int column = 0;
            while (column < 20) {
                MazeCell cell = this.getLocation(row % 20, column % 20);
                int x = column * cellSize.width;
                int y = this.image.getHeight() - (row + 1) * cellSize.height - 1;
                cell.draw(g, x, y);
                ++column;
            }
            ++row;
        }
        return this.image;
    }

    public void setMessages(List<Message> messages) {
        this.messages = messages;
    }

    public void setMonsters(List<Monster> monsters) {
        this.monsters = monsters;
    }

    public void setItems(List<Item> items) {
        this.items = items;
    }

    public MazeCell getLocation(int row, int column) {
        MazeAddress address = new MazeAddress(this.level, row, column);
        MazeCell cell = new MazeCell(address);
        int offset = column * 6 + row / 4;
        int value = HexFormatter.intValue(this.buffer[offset]);
        cell.westWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.westDoor = ((value >>>= 1) & 1) == 1;
        value = HexFormatter.intValue(this.buffer[offset + 120]);
        cell.southWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.southDoor = ((value >>>= 1) & 1) == 1;
        value = HexFormatter.intValue(this.buffer[offset + 240]);
        cell.eastWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.eastDoor = ((value >>>= 1) & 1) == 1;
        value = HexFormatter.intValue(this.buffer[offset + 360]);
        cell.northWall = ((value >>>= row % 4 * 2) & 1) == 1;
        cell.northDoor = ((value >>>= 1) & 1) == 1;
        offset = column * 4 + row / 8;
        value = HexFormatter.intValue(this.buffer[offset + 480]);
        cell.monsterLair = ((value >>>= row % 8) & 1) == 1;
        offset = column * 10 + row / 2;
        value = HexFormatter.intValue(this.buffer[offset + 560]);
        int b = row % 2 == 0 ? value % 16 : value / 16;
        int c = HexFormatter.intValue(this.buffer[760 + b / 2]);
        int d = b % 2 == 0 ? c % 16 : c / 16;
        switch (d) {
            case 1: {
                cell.stairs = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 2: {
                cell.pit = true;
                break;
            }
            case 3: {
                cell.chute = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 4: {
                cell.spinner = true;
                break;
            }
            case 5: {
                cell.darkness = true;
                break;
            }
            case 6: {
                cell.teleport = true;
                cell.addressTo = this.getAddress(b);
                break;
            }
            case 8: {
                cell.elevator = true;
                cell.elevatorTo = HexFormatter.intValue(this.buffer[800 + b * 2], this.buffer[801 + b * 2]);
                cell.elevatorFrom = HexFormatter.intValue(this.buffer[832 + b * 2], this.buffer[833 + b * 2]);
                break;
            }
            case 9: {
                cell.rock = true;
                break;
            }
            case 10: {
                cell.spellsBlocked = true;
                break;
            }
            case 11: {
                int messageNum = HexFormatter.intValue(this.buffer[800 + b * 2], this.buffer[801 + b * 2]);
                for (Message m : this.messages) {
                    if (!m.match(messageNum)) continue;
                    cell.message = m;
                    break;
                }
                if (cell.message == null) {
                    System.out.println("message not found : " + messageNum);
                }
                cell.messageType = HexFormatter.intValue(this.buffer[832 + b * 2], this.buffer[833 + b * 2]);
                int itemID = -1;
                if (cell.messageType == 2) {
                    itemID = HexFormatter.intValue(this.buffer[768 + b * 2], this.buffer[769 + b * 2]);
                    cell.itemObtained = this.items.get(itemID);
                }
                if (cell.messageType == 5) {
                    itemID = HexFormatter.intValue(this.buffer[768 + b * 2], this.buffer[769 + b * 2]);
                    cell.itemRequired = this.items.get(itemID);
                }
                if (cell.messageType != 4) break;
                value = HexFormatter.intValue(this.buffer[768 + b * 2], this.buffer[769 + b * 2]);
                if (value <= 100) {
                    cell.monsterID = value;
                    cell.monsters = this.monsters;
                    break;
                }
                int val = (value - 64536) * -1;
                System.out.println("Value : " + val);
                if (val < this.items.size()) {
                    cell.itemObtained = this.items.get(val);
                }
                if (cell.itemObtained != null) break;
                System.out.printf("Item %d not found%n", val);
                break;
            }
            case 12: {
                cell.monsterID = HexFormatter.intValue(this.buffer[832 + b * 2], this.buffer[833 + b * 2]);
                cell.monsters = this.monsters;
                break;
            }
            default: {
                cell.unknown = d;
            }
        }
        return cell;
    }

    private MazeAddress getAddress(int a) {
        int b = a * 2;
        return new MazeAddress(HexFormatter.intValue(this.buffer[768 + b], this.buffer[769 + b]), HexFormatter.intValue(this.buffer[800 + b], this.buffer[801 + b]), HexFormatter.intValue(this.buffer[832 + b], this.buffer[833 + b]));
    }

    public int getRows() {
        return 20;
    }

    public int getColumns() {
        return 20;
    }
}

