/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosDirectory;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.util.ArrayList;
import java.util.List;

class VolumeDirectoryHeader
extends DirectoryHeader {
    int bitMapBlock;
    int totalBlocks;
    int freeBlocks;
    int usedBlocks;
    int totalBitMapBlocks;

    public VolumeDirectoryHeader(ProdosDisk parentDisk, byte[] entryBuffer) {
        super(parentDisk, entryBuffer);
        byte[] buffer;
        this.bitMapBlock = HexFormatter.intValue(entryBuffer[35], entryBuffer[36]);
        this.totalBlocks = HexFormatter.intValue(entryBuffer[37], entryBuffer[38]);
        this.totalBitMapBlocks = (this.totalBlocks * 8 - 1) / 4096 + 1;
        if (this.totalBlocks == 65535) {
            this.totalBlocks = (int)this.disk.getFile().length() / 512;
        }
        int block = 2;
        do {
            this.dataBlocks.add(this.disk.getDiskAddress(block));
        } while ((block = HexFormatter.intValue((buffer = this.disk.readSector(block))[2], buffer[3])) > 0);
        int bitMapBytes = this.totalBlocks / 8;
        byte[] buffer2 = new byte[bitMapBytes];
        int bitMapBlocks = (bitMapBytes - 1) / this.disk.getSectorsPerTrack() + 1;
        int lastBitMapBlock = this.bitMapBlock + bitMapBlocks - 1;
        int ptr = 0;
        block = this.bitMapBlock;
        while (block <= lastBitMapBlock) {
            int bytesToCopy = buffer2.length - ptr;
            byte[] temp = this.disk.readSector(block);
            if (bytesToCopy > temp.length) {
                bytesToCopy = temp.length;
            }
            System.arraycopy(temp, 0, buffer2, ptr, bytesToCopy);
            ptr += bytesToCopy;
            ++block;
        }
        block = 0;
        int i = 0;
        while (i < buffer2.length) {
            byte b = buffer2[i];
            int j = 0;
            while (j < 8) {
                if ((b & 0x80) == 128) {
                    ++this.freeBlocks;
                    parentDisk.setSectorFree(block++, true);
                } else {
                    ++this.usedBlocks;
                    parentDisk.setSectorFree(block++, false);
                }
                b = (byte)(b << 1);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public DataSource getDataSource() {
        byte[] buf;
        ArrayList<byte[]> blockList = new ArrayList<byte[]>();
        int block = 2;
        do {
            buf = this.disk.readSector(block);
            blockList.add(buf);
        } while ((block = HexFormatter.intValue(buf[2], buf[3])) > 0);
        byte[] fullBuffer = new byte[blockList.size() * 507];
        int offset = 0;
        for (byte[] bfr : blockList) {
            System.arraycopy(bfr, 4, fullBuffer, offset, 507);
            offset += 507;
        }
        return new ProdosDirectory(this.disk, this.name, fullBuffer, this.totalBlocks, this.freeBlocks, this.usedBlocks);
    }

    @Override
    public List<DiskAddress> getSectors() {
        ArrayList<DiskAddress> sectors = new ArrayList<DiskAddress>();
        sectors.addAll(this.dataBlocks);
        return sectors;
    }

    public String toString() {
        return this.name;
    }
}

