/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.gui.DataSource;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.FileEntry;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.util.List;

class SubDirectoryHeader
extends DirectoryHeader {
    int parentPointer;
    int parentSequence;
    int parentSize;

    public SubDirectoryHeader(ProdosDisk parentDisk, byte[] entryBuffer, FileEntry parent) {
        super(parentDisk, entryBuffer);
        this.parentDirectory = parent.parentDirectory;
        this.parentPointer = HexFormatter.intValue(entryBuffer[35], entryBuffer[36]);
        this.parentSequence = HexFormatter.intValue(entryBuffer[37]);
        this.parentSize = HexFormatter.intValue(entryBuffer[38]);
    }

    public String toString() {
        String locked = this.access == 1 ? "*" : " ";
        return String.format("   %s%-40s %15s", locked, "/" + this.name, ProdosDisk.df.format(this.created.getTime()));
    }

    @Override
    public DataSource getDataSource() {
        return null;
    }

    @Override
    public List<DiskAddress> getSectors() {
        return null;
    }
}

