/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.AbstractSector;

class ProdosExtendedKeySector
extends AbstractSector {
    public ProdosExtendedKeySector(byte[] buffer) {
        super(buffer);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Prodos Extended Key Block");
        int i = 0;
        while (i < 512) {
            this.addText(text, this.buffer, i, 1, "Storage type (" + this.getType(this.buffer[i]) + ")");
            this.addTextAndDecimal(text, this.buffer, i + 1, 2, "Key block");
            this.addTextAndDecimal(text, this.buffer, i + 3, 2, "Blocks used");
            this.addTextAndDecimal(text, this.buffer, i + 5, 3, "EOF");
            text.append("\n");
            i += 256;
        }
        return text.toString();
    }

    private String getType(byte flag) {
        switch (flag & 0xF) {
            case 1: {
                return "Seedling";
            }
            case 2: {
                return "Sapling";
            }
            case 3: {
                return "Tree";
            }
        }
        return "???";
    }
}

