/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.prodos.ProdosConstants;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.util.GregorianCalendar;

class ProdosCatalogSector
extends AbstractSector {
    ProdosCatalogSector(byte[] buffer) {
        super(buffer);
    }

    @Override
    public String createText() {
        StringBuilder text = this.getHeader("Prodos Catalog Sector");
        this.addTextAndDecimal(text, this.buffer, 0, 2, "Previous block");
        this.addTextAndDecimal(text, this.buffer, 2, 2, "Next block");
        int i = 4;
        int max = this.buffer.length - 39;
        while (i <= max) {
            if (this.buffer[i] == 0 && this.buffer[i + 1] == 0) break;
            text.append("\n");
            int fileType = (this.buffer[i] & 0xF0) >> 4;
            int nameLength = this.buffer[i] & 0xF;
            String typeText = String.valueOf(fileType) + " = " + this.getType(this.buffer[i]);
            if (fileType == 0) {
                this.addText(text, this.buffer, i, 1, String.valueOf(typeText) + " : " + this.getDeletedName(i + 1));
            } else {
                this.addText(text, this.buffer, i, 1, String.valueOf(typeText) + ", " + nameLength + " = Name length");
            }
            this.addText(text, this.buffer, i + 1, 4, HexFormatter.getString(this.buffer, i + 1, nameLength));
            switch (fileType) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 13: {
                    text.append(this.doFileDescription(i));
                    break;
                }
                case 14: {
                    text.append(this.doSubdirectoryHeader(i));
                    break;
                }
                case 15: {
                    text.append(this.doVolumeDirectoryHeader(i));
                    break;
                }
                default: {
                    text.append("Unknown\n");
                }
            }
            i += 39;
        }
        if (text.length() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }

    private String doFileDescription(int offset) {
        StringBuilder text = new StringBuilder();
        int fileType = HexFormatter.intValue(this.buffer[offset + 16]);
        this.addText(text, this.buffer, offset + 16, 1, "File type (" + ProdosConstants.fileTypes[fileType] + ")");
        this.addTextAndDecimal(text, this.buffer, offset + 17, 2, "Key pointer");
        this.addTextAndDecimal(text, this.buffer, offset + 19, 2, "Blocks used");
        this.addTextAndDecimal(text, this.buffer, offset + 21, 3, "EOF");
        GregorianCalendar created = HexFormatter.getAppleDate(this.buffer, offset + 24);
        String dateC = created == null ? "" : ProdosDisk.df.format(created.getTime());
        this.addText(text, this.buffer, offset + 24, 4, "Creation date : " + dateC);
        this.addTextAndDecimal(text, this.buffer, offset + 28, 1, "Version");
        this.addText(text, this.buffer, offset + 29, 1, "Minimum version");
        this.addText(text, this.buffer, offset + 30, 1, "Access");
        this.addTextAndDecimal(text, this.buffer, offset + 31, 2, "Auxilliary type - " + this.getAuxilliaryText(fileType));
        GregorianCalendar modified = HexFormatter.getAppleDate(this.buffer, offset + 33);
        String dateM = modified == null ? "" : ProdosDisk.df.format(modified.getTime());
        this.addText(text, this.buffer, offset + 33, 4, "Modification date : " + dateM);
        this.addTextAndDecimal(text, this.buffer, offset + 37, 2, "Header pointer");
        return text.toString();
    }

    private String doVolumeDirectoryHeader(int offset) {
        StringBuilder text = new StringBuilder();
        this.addText(text, this.buffer, offset + 16, 4, "Not used");
        text.append(this.getCommonHeader(offset));
        this.addTextAndDecimal(text, this.buffer, offset + 35, 2, "Bit map pointer");
        this.addTextAndDecimal(text, this.buffer, offset + 37, 2, "Total blocks");
        return text.toString();
    }

    private String doSubdirectoryHeader(int offset) {
        StringBuilder text = new StringBuilder();
        this.addText(text, this.buffer, offset + 16, 1, "Hex $75");
        this.addText(text, this.buffer, offset + 17, 3, "Not used");
        text.append(this.getCommonHeader(offset));
        this.addTextAndDecimal(text, this.buffer, offset + 35, 2, "Parent block");
        this.addTextAndDecimal(text, this.buffer, offset + 37, 1, "Parent entry number");
        this.addTextAndDecimal(text, this.buffer, offset + 38, 1, "Parent entry length");
        return text.toString();
    }

    private String getCommonHeader(int offset) {
        StringBuilder text = new StringBuilder();
        this.addText(text, this.buffer, offset + 20, 4, "Not used");
        GregorianCalendar created = HexFormatter.getAppleDate(this.buffer, offset + 24);
        String dateC = created == null ? "" : ProdosDisk.df.format(created.getTime());
        this.addText(text, this.buffer, offset + 24, 4, "Creation date : " + dateC);
        this.addText(text, this.buffer, offset + 28, 1, "Prodos version");
        this.addText(text, this.buffer, offset + 29, 1, "Minimum version");
        this.addText(text, this.buffer, offset + 30, 1, "Access");
        this.addTextAndDecimal(text, this.buffer, offset + 31, 1, "Entry length");
        this.addTextAndDecimal(text, this.buffer, offset + 32, 1, "Entries per block");
        this.addTextAndDecimal(text, this.buffer, offset + 33, 2, "File count");
        return text.toString();
    }

    private String getAuxilliaryText(int fileType) {
        switch (fileType) {
            case 4: {
                return "record length";
            }
            case 253: {
                return "address of stored variables";
            }
            case 6: 
            case 252: 
            case 255: {
                return "load address";
            }
        }
        return "???";
    }

    private String getType(byte flag) {
        switch ((flag & 0xF0) >> 4) {
            case 0: {
                return "Deleted";
            }
            case 1: {
                return "Seedling";
            }
            case 2: {
                return "Sapling";
            }
            case 3: {
                return "Tree";
            }
            case 4: {
                return "Pascal area on a Profile HD";
            }
            case 5: {
                return "GS/OS extended file";
            }
            case 13: {
                return "Subdirectory";
            }
            case 14: {
                return "Subdirectory Header";
            }
            case 15: {
                return "Volume Directory Header";
            }
        }
        return "???";
    }

    private String getDeletedName(int offset) {
        StringBuilder text = new StringBuilder();
        int i = offset;
        int max = offset + 15;
        while (i < max && this.buffer[i] != 0) {
            text.append((char)HexFormatter.intValue(this.buffer[i]));
            ++i;
        }
        return text.toString();
    }
}

