/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.disk.AbstractSector;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.awt.Dimension;

class ProdosBitMapSector
extends AbstractSector {
    DiskAddress da;
    ProdosDisk parent;

    ProdosBitMapSector(ProdosDisk parent, byte[] buffer, DiskAddress da) {
        super(buffer);
        this.da = da;
        this.parent = parent;
    }

    @Override
    public String createText() {
        Dimension grid = this.parent.getGridLayout();
        int startBit = (this.da.getBlock() - this.parent.vdh.bitMapBlock) * 4096;
        int endBit = startBit + 4096;
        if (startBit >= grid.width * grid.height) {
            return "This sector is not used - the physical file size makes it unnecessary";
        }
        int block = 0;
        int width = (grid.width - 1) / 8 + 1;
        StringBuilder text = this.getHeader("Prodos Bit Map Sector");
        int row = 0;
        while (row < grid.height) {
            int offset = block / 8;
            StringBuilder details = new StringBuilder();
            int col = 0;
            while (col < grid.width) {
                details.append(this.parent.isSectorFree(block++) ? ". " : "X ");
                ++col;
            }
            this.addText(text, this.buffer, offset, width, details.toString());
            ++row;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

