/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.prodos;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.prodos.DirectoryHeader;
import com.bytezone.diskbrowser.prodos.ProdosDisk;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;

abstract class CatalogEntry
implements AppleFileSource {
    FormattedDisk parentDisk;
    DirectoryHeader parentDirectory;
    String name;
    int storageType;
    GregorianCalendar created;
    int version;
    int minVersion;
    int access;
    List<DiskAddress> dataBlocks = new ArrayList<DiskAddress>();
    Disk disk;

    public CatalogEntry(ProdosDisk parentDisk, byte[] entryBuffer) {
        this.parentDisk = parentDisk;
        this.disk = parentDisk.getDisk();
        this.name = HexFormatter.getString(entryBuffer, 1, entryBuffer[0] & 0xF);
        this.storageType = (entryBuffer[0] & 0xF0) >> 4;
        this.created = HexFormatter.getAppleDate(entryBuffer, 24);
        this.version = HexFormatter.intValue(entryBuffer[28]);
        this.minVersion = HexFormatter.intValue(entryBuffer[29]);
        this.access = HexFormatter.intValue(entryBuffer[30]);
    }

    @Override
    public String getUniqueName() {
        if (this.parentDirectory == null) {
            return this.name;
        }
        return String.valueOf(this.parentDirectory.getUniqueName()) + "/" + this.name;
    }

    @Override
    public FormattedDisk getFormattedDisk() {
        return this.parentDisk;
    }
}

