/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Header;

class ZString {
    private static String[] letters = new String[]{"      abcdefghijklmnopqrstuvwxyz", "      ABCDEFGHIJKLMNOPQRSTUVWXYZ", "        0123456789.,!?_#'\"/\\-:()"};
    String value;
    Header header;
    int startPtr;
    int length;

    public ZString(byte[] buffer, int offset, Header header) {
        ZStringBuilder text = new ZStringBuilder();
        this.header = header;
        this.startPtr = offset;
        while (true) {
            if (offset >= header.buffer.length - 1) {
                System.out.println("********" + text.toString());
                break;
            }
            int val = header.getWord(offset);
            text.processZChar((byte)(val >> 10 & 0x1F));
            text.processZChar((byte)(val >> 5 & 0x1F));
            text.processZChar((byte)(val & 0x1F));
            if ((val & 0x8000) > 0) {
                this.length = offset - this.startPtr + 2;
                this.value = text.toString();
                break;
            }
            offset += 2;
        }
    }

    public String toString() {
        return this.value;
    }

    private class ZStringBuilder {
        int alphabet;
        boolean shift;
        int shiftAlphabet;
        int synonym;
        int buildingLevel;
        int builtLetter;
        StringBuilder text = new StringBuilder();

        private ZStringBuilder() {
        }

        private void processZChar(byte zchar) {
            if (this.buildingLevel > 0) {
                this.builtLetter = (short)(this.builtLetter << 5 | zchar);
                if (++this.buildingLevel == 3) {
                    this.text.append((char)this.builtLetter);
                    this.buildingLevel = 0;
                }
                return;
            }
            if (this.synonym > 0) {
                this.text.append(ZString.this.header.getAbbreviation((this.synonym - 1) * 32 + zchar));
                this.synonym = 0;
                return;
            }
            if (this.shift && this.shiftAlphabet == 2 || !this.shift && this.alphabet == 2) {
                if (zchar == 6) {
                    this.buildingLevel = 1;
                    this.builtLetter = 0;
                    this.shift = false;
                    return;
                }
                if (zchar == 7) {
                    this.text.append("\n");
                    this.shift = false;
                    return;
                }
            }
            switch (zchar) {
                case 0: {
                    this.text.append(" ");
                    this.shift = false;
                    return;
                }
                case 1: {
                    this.synonym = zchar;
                    return;
                }
                case 2: 
                case 3: {
                    if (ZString.this.header.version >= 3) {
                        this.synonym = zchar;
                        return;
                    }
                    this.shiftAlphabet = (this.alphabet + zchar - 1) % 3;
                    this.shift = true;
                    return;
                }
                case 4: 
                case 5: {
                    if (ZString.this.header.version >= 3) {
                        this.shiftAlphabet = zchar - 3;
                        this.shift = true;
                    } else {
                        this.alphabet = (this.alphabet + zchar - 3) % 3;
                    }
                    return;
                }
            }
            if (this.shift) {
                this.text.append(letters[this.shiftAlphabet].charAt(zchar));
                this.shift = false;
            } else {
                this.text.append(letters[this.alphabet].charAt(zchar));
            }
        }

        public String toString() {
            return this.text.toString();
        }
    }
}

