/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.Routine;
import com.bytezone.diskbrowser.infocom.ZString;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;

class ZObject
extends AbstractFile {
    static final int HEADER_SIZE = 9;
    int id;
    int startPtr;
    int propertyTablePtr;
    int propertyTableLength;
    int parent;
    int sibling;
    int child;
    List<Property> properties = new ArrayList<Property>();
    Header header;
    BitSet attributes = new BitSet(32);

    public ZObject(String name, byte[] buffer, int offset, int seq, Header header) {
        super(name, buffer);
        this.header = header;
        this.startPtr = offset;
        this.id = seq;
        int bitIndex = 0;
        int i = 0;
        while (i < 4) {
            byte b = buffer[offset + i];
            int j = 0;
            while (j < 8) {
                if ((b & 0x80) == 128) {
                    this.attributes.set(bitIndex);
                }
                b = (byte)(b << 1);
                ++bitIndex;
                ++j;
            }
            ++i;
        }
        this.parent = header.getByte(offset + 4);
        this.sibling = header.getByte(offset + 5);
        this.child = header.getByte(offset + 6);
        this.propertyTablePtr = header.getWord(offset + 7);
        int ptr = this.propertyTablePtr;
        int nameLength = header.getByte(ptr) * 2;
        this.name = nameLength == 0 ? "<<none>>" : new ZString((byte[])buffer, (int)(++ptr), (Header)header).value;
        ptr += nameLength;
        while (buffer[ptr] != 0) {
            Property p = new Property(buffer, ptr);
            this.properties.add(p);
            ptr += p.length + 1;
        }
        this.propertyTableLength = ptr - this.propertyTablePtr;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        text.append(String.format("ID       : %3d   %s%n%nAttributes : ", this.id, this.name));
        text.append(HexFormatter.getHexString(this.buffer, this.startPtr, 4));
        text.append("   " + this.attributes.toString());
        String obj1 = this.parent == 0 ? "" : this.header.objectManager.list.get((int)(this.parent - 1)).name;
        String obj2 = this.sibling == 0 ? "" : this.header.objectManager.list.get((int)(this.sibling - 1)).name;
        String obj3 = this.child == 0 ? "" : this.header.objectManager.list.get((int)(this.child - 1)).name;
        text.append(String.format("%n%nParent   : %02X  (%3d)  %s%n", this.parent, this.parent, obj1));
        text.append(String.format("Sibling  : %02X  (%3d)  %s%n", this.sibling, this.sibling, obj2));
        text.append(String.format("Child    : %02X  (%3d)  %s%n%n", this.child, this.child, obj3));
        for (Property prop : this.properties) {
            text.append(prop + "\n");
        }
        return text.toString();
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder("Header :\n\n");
        text.append(HexFormatter.formatNoHeader(this.buffer, this.startPtr, 9));
        text.append("\n\nProperty table:\n\n");
        text.append(HexFormatter.formatNoHeader(this.buffer, this.propertyTablePtr, this.propertyTableLength));
        return text.toString();
    }

    Property getProperty(int id) {
        for (Property p : this.properties) {
            if (p.propertyNumber != id) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(HexFormatter.getHexString(this.buffer, this.startPtr, 9)) + "   " + this.name;
    }

    class Property {
        int propertyNumber;
        int ptr;
        int length;
        int offset;

        public Property(byte[] buffer, int ptr) {
            this.ptr = ptr;
            this.length = ZObject.this.header.getByte(ptr) / 32 + 1;
            this.propertyNumber = ZObject.this.header.getByte(ptr) % 32;
            if (this.length == 2) {
                this.offset = ZObject.this.header.getWord(ptr + 1) * 2;
            }
        }

        private ZObject getObject() {
            return ZObject.this.header.objectManager.list.get((ZObject.this.buffer[this.ptr + 1] & 0xFF) - 1);
        }

        public String toString() {
            StringBuilder text;
            block18: {
                String propertyType;
                block17: {
                    text = new StringBuilder(String.format("%5s : ", ZObject.this.header.propertyNames[this.propertyNumber]));
                    propertyType = ZObject.this.header.propertyNames[this.propertyNumber];
                    if (!propertyType.equals("DICT") && !propertyType.contains("STR")) {
                        text.append(String.format("%-20s", HexFormatter.getHexString(ZObject.this.buffer, this.ptr + 1, this.length)));
                    }
                    if (propertyType.charAt(0) < 'a') break block17;
                    switch (this.length) {
                        case 1: {
                            text.append(this.getObject().name);
                            break;
                        }
                        case 2: {
                            text.append("\"" + ZObject.this.header.stringManager.stringAt(this.offset) + "\"");
                            break;
                        }
                        case 3: {
                            int address = ZObject.this.header.getWord(this.ptr + 1) * 2;
                            text.append(String.format("R:%05X", address));
                            break;
                        }
                        case 4: {
                            int address = ZObject.this.header.getWord(this.ptr + 3) * 2;
                            if (address > 0) {
                                text.append("\"" + ZObject.this.header.stringManager.stringAt(address) + "\"");
                                break;
                            } else {
                                break;
                            }
                        }
                    }
                    break block18;
                }
                if (propertyType.equals("DICT")) {
                    int i = 1;
                    while (i <= this.length) {
                        int address = ZObject.this.header.getWord(this.ptr + i);
                        text.append(String.valueOf(ZObject.this.header.wordAt(address)) + ", ");
                        i += 2;
                    }
                    text.deleteCharAt(text.length() - 1);
                    text.deleteCharAt(text.length() - 1);
                } else if (propertyType.startsWith("CODE")) {
                    if (this.offset > 0) {
                        Routine r = ZObject.this.header.codeManager.getRoutine(this.offset);
                        if (r != null) {
                            text.append("\n\n" + r.getText());
                        } else {
                            text.append("\n\n****** null routine\n");
                        }
                    }
                } else if (propertyType.startsWith("STR")) {
                    text.append(String.format("(%4X) \"%s\"", this.offset, ZObject.this.header.stringManager.stringAt(this.offset)));
                }
            }
            return text.toString();
        }
    }
}

