/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Condition;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class PropertyTester
implements Iterable<Integer> {
    List<ZObject> objects;
    List<Condition> conditions = new ArrayList<Condition>();
    List<Integer> matchedProperties;

    public PropertyTester(List<ZObject> objects) {
        this.objects = objects;
    }

    public void addTest(Condition test) {
        this.conditions.add(test);
    }

    public void doTests() {
        boolean[] propFail = new boolean[32];
        int[] propTestCount = new int[32];
        this.matchedProperties = new ArrayList<Integer>();
        for (ZObject object : this.objects) {
            block1: for (ZObject.Property property : object.properties) {
                if (propFail[property.propertyNumber] || property.length == 0) continue;
                for (Condition condition : this.conditions) {
                    if (condition.test(property)) continue;
                    propFail[property.propertyNumber] = true;
                    continue block1;
                }
                int n = property.propertyNumber;
                propTestCount[n] = propTestCount[n] + 1;
            }
        }
        int i = 1;
        while (i < propFail.length) {
            if (!propFail[i] && propTestCount[i] > 0) {
                this.matchedProperties.add(i);
            }
            ++i;
        }
    }

    @Override
    public Iterator<Integer> iterator() {
        return this.matchedProperties.iterator();
    }

    public int totalSuccessfulProperties() {
        return this.matchedProperties.size();
    }
}

