/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ObjectAnalyser;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;

class ObjectManager
extends AbstractFile
implements Iterable<ZObject> {
    Header header;
    List<ZObject> list;
    int defaultsPtr;
    int defaultsSize;
    int tablePtr;
    int tableSize;
    int propertyPtr;
    int propertySize;
    ObjectAnalyser analyser;

    public ObjectManager(Header header) {
        super("Objects", header.buffer);
        this.header = header;
        this.defaultsPtr = header.objectTable;
        this.defaultsSize = 62;
        this.tablePtr = header.objectTable + 62;
        this.propertyPtr = header.getWord(this.tablePtr + 7);
        this.propertySize = header.globalsOffset - this.propertyPtr;
        this.tableSize = this.propertyPtr - this.tablePtr;
        int totalObjects = this.tableSize / 9;
        this.list = new ArrayList<ZObject>(this.tableSize);
        int objectNo = 0;
        while (objectNo < totalObjects) {
            this.list.add(new ZObject(null, this.buffer, this.tablePtr + objectNo * 9, objectNo + 1, header));
            ++objectNo;
        }
        this.analyser = new ObjectAnalyser(header, this);
        this.hexBlocks.add(new AbstractFile.HexBlock(this.defaultsPtr, this.defaultsSize, "Property defaults:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.tablePtr, this.tableSize, "Objects table:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.propertyPtr, this.propertySize, "Properties:"));
    }

    public void addNodes(DefaultMutableTreeNode root, FormattedDisk disk) {
        root.setAllowsChildren(true);
        for (ZObject zo : this.list) {
            if (zo.parent != 0) continue;
            this.buildObjectTree(zo, root, disk);
        }
    }

    private void buildObjectTree(ZObject object, DefaultMutableTreeNode parentNode, FormattedDisk disk) {
        DefaultMutableTreeNode child = new DefaultMutableTreeNode(new DefaultAppleFileSource(object.name, object, disk));
        parentNode.add(child);
        if (object.sibling > 0) {
            this.buildObjectTree(this.header.objectManager.list.get(object.sibling - 1), parentNode, disk);
        }
        if (object.child > 0) {
            this.buildObjectTree(this.header.objectManager.list.get(object.child - 1), child, disk);
        } else {
            child.setAllowsChildren(false);
        }
    }

    public List<Integer> getCodeRoutines() {
        return this.analyser.routines;
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("  #   Attributes  Pr Sb Ch  Prop   Title\n---   ----------- -- -- -- -----   -----------------------------\n");
        int objectNumber = 0;
        for (ZObject zo : this.list) {
            text.append(String.format("%3d   %s%n", ++objectNumber, zo));
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    @Override
    public Iterator<ZObject> iterator() {
        return this.list.iterator();
    }
}

