/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.infocom.Condition;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ObjectManager;
import com.bytezone.diskbrowser.infocom.PropertyTester;
import com.bytezone.diskbrowser.infocom.ZObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class ObjectAnalyser {
    Header header;
    ObjectManager parent;
    List<Statistics> list = new ArrayList<Statistics>();
    List<Integer> routines = new ArrayList<Integer>();

    public ObjectAnalyser(Header header, ObjectManager parent) {
        this.header = header;
        this.parent = parent;
        this.setDictionary();
        this.setStringPointer();
        this.createPropertyLinks();
    }

    public void setStringPointer() {
        PropertyTester pt = new PropertyTester(this.parent.list);
        pt.addTest(new LengthTwoCondition());
        HighMemoryCondition hmc = new HighMemoryCondition();
        pt.addTest(hmc);
        pt.doTests();
        System.out.println("\nSetting the string pointer\n");
        for (Integer propertyNo : pt) {
            this.list.add(hmc.statistics[propertyNo]);
        }
        Collections.sort(this.list);
        int lo = this.list.get((int)0).lo;
        for (Statistics s : this.list) {
            System.out.println(s);
            if (s.hi > lo && s.lo < lo) {
                lo = s.lo;
            }
            if (s.hi >= lo) continue;
            this.header.stringPointer = lo;
            break;
        }
    }

    public void createPropertyLinks() {
        int sCount = 0;
        int rCount = 0;
        int totStrings = 0;
        int totRoutines = 0;
        for (Statistics s : this.list) {
            if (this.header.propertyNames[s.propertyNumber].charAt(0) >= 'a') continue;
            if (s.lo >= this.header.stringPointer) {
                this.header.propertyNames[s.propertyNumber] = "STR" + ++sCount;
                totStrings += s.offsets.size();
                continue;
            }
            this.header.propertyNames[s.propertyNumber] = "CODE" + ++rCount;
            this.routines.addAll(s.offsets);
            totRoutines += s.offsets.size();
        }
        System.out.println("Strings found : " + totStrings);
        System.out.println("Routines found : " + totRoutines);
    }

    public void checkThreeByteProperties() {
        for (ZObject object : this.parent.list) {
            for (ZObject.Property property : object.properties) {
                if (this.header.propertyNames[property.propertyNumber].charAt(0) >= 'a' || property.length != 3) continue;
                int address = this.header.getWord(property.ptr + 1) * 2;
                System.out.println("checking " + address);
                this.header.codeManager.addRoutine(address, 0);
            }
        }
    }

    public void setDictionary() {
        PropertyTester pt = new PropertyTester(this.parent.list);
        pt.addTest(new LengthEvenCondition());
        pt.addTest(new ValidDictionaryCondition());
        pt.doTests();
        for (Integer i : pt) {
            this.header.propertyNames[i.intValue()] = "DICT";
        }
    }

    class HighMemoryCondition
    extends Condition {
        int lo;
        int hi;
        Statistics[] statistics = new Statistics[32];

        public HighMemoryCondition() {
            this.lo = ObjectAnalyser.this.header.highMemory;
            this.hi = ObjectAnalyser.this.header.fileLength;
            int i = 1;
            while (i < this.statistics.length) {
                this.statistics[i] = new Statistics(i);
                ++i;
            }
        }

        @Override
        boolean test(ZObject.Property property) {
            this.statistics[property.propertyNumber].increment(property);
            int address = ObjectAnalyser.this.header.getWord(property.ptr + 1) * 2;
            return address >= this.lo && address < this.hi || address == 0;
        }
    }

    class LengthEvenCondition
    extends Condition {
        LengthEvenCondition() {
        }

        @Override
        boolean test(ZObject.Property property) {
            return property.length % 2 == 0;
        }
    }

    class LengthThreeCondition
    extends Condition {
        LengthThreeCondition() {
        }

        @Override
        boolean test(ZObject.Property property) {
            return property.length == 3;
        }
    }

    class LengthTwoCondition
    extends Condition {
        LengthTwoCondition() {
        }

        @Override
        boolean test(ZObject.Property property) {
            return property.length == 2;
        }
    }

    class Statistics
    implements Comparable<Statistics> {
        int propertyNumber;
        int lo;
        int hi;
        List<Integer> offsets = new ArrayList<Integer>();

        public Statistics(int propertyNumber) {
            this.propertyNumber = propertyNumber;
        }

        public void increment(ZObject.Property property) {
            this.offsets.add(property.offset);
            if (property.offset > this.hi) {
                this.hi = property.offset;
            }
            if (property.offset < this.lo || this.lo == 0) {
                this.lo = property.offset;
            }
        }

        public String toString() {
            return String.format("%2d   %3d   %,7d   %,7d", this.propertyNumber, this.offsets.size(), this.lo, this.hi);
        }

        @Override
        public int compareTo(Statistics o) {
            return o.hi - this.hi;
        }
    }

    class ValidDictionaryCondition
    extends Condition {
        ValidDictionaryCondition() {
        }

        @Override
        boolean test(ZObject.Property property) {
            int i = 1;
            while (i <= property.length) {
                int address = ObjectAnalyser.this.header.getWord(property.ptr + i);
                if (!ObjectAnalyser.this.header.containsWordAt(address)) {
                    return false;
                }
                i += 2;
            }
            return true;
        }
    }
}

