/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class Grammar
extends AbstractFile {
    private static final int SENTENCE_LENGTH = 8;
    Header header;
    int indexPtr;
    int indexSize;
    int tablePtr;
    int tableSize;
    int actionPtr;
    int actionSize;
    int preActionPtr;
    int preActionSize;
    int prepositionPtr;
    int prepositionSize;
    int indexEntries;
    int totalPrepositions;
    int padding;
    List<SentenceGroup> sentenceGroups = new ArrayList<SentenceGroup>();
    Map<Integer, List<Sentence>> actionList = new TreeMap<Integer, List<Sentence>>();
    List<Integer> actionRoutines = new ArrayList<Integer>();
    List<Integer> preActionRoutines = new ArrayList<Integer>();

    public Grammar(String name, byte[] buffer, Header header) {
        super(name, buffer);
        this.header = header;
        this.indexPtr = header.staticMemory;
        this.tablePtr = header.getWord(this.indexPtr);
        this.indexSize = this.tablePtr - this.indexPtr;
        this.indexEntries = this.indexSize / 2;
        this.padding = this.getPadding();
        int lastEntry = header.getWord(this.tablePtr - 2);
        this.tableSize = lastEntry + this.getRecordLength(lastEntry) - this.tablePtr;
        this.actionPtr = this.tablePtr + this.tableSize;
        this.preActionSize = this.actionSize = this.getTotalActions() * 2;
        this.preActionPtr = this.actionPtr + this.actionSize;
        this.prepositionPtr = this.preActionPtr + this.preActionSize;
        this.totalPrepositions = header.getWord(this.prepositionPtr);
        this.prepositionSize = this.totalPrepositions * 4 + 2;
        this.hexBlocks.add(new AbstractFile.HexBlock(this.indexPtr, this.indexSize, "Index:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.tablePtr, this.tableSize, "Grammar data:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.actionPtr, this.actionSize, "Action routines:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.preActionPtr, this.preActionSize, "Pre-action routines:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.prepositionPtr, this.prepositionSize, "Preposition table:"));
        int count = 255;
        int i = 0;
        while (i < this.indexEntries) {
            int offset = header.getWord(this.indexPtr + i * 2);
            SentenceGroup sg = new SentenceGroup(count--, offset);
            this.sentenceGroups.add(sg);
            for (Sentence sentence : sg) {
                if (!this.actionList.containsKey(sentence.actionId)) {
                    this.actionList.put(sentence.actionId, new ArrayList());
                }
                this.actionList.get(sentence.actionId).add(sentence);
                if (sentence.preActionRoutine > 0 && !this.preActionRoutines.contains(sentence.preActionRoutine)) {
                    this.preActionRoutines.add(sentence.preActionRoutine);
                }
                if (sentence.actionRoutine <= 0 || this.actionRoutines.contains(sentence.actionRoutine)) continue;
                this.actionRoutines.add(sentence.actionRoutine);
            }
            ++i;
        }
        Collections.sort(this.actionRoutines);
        Collections.sort(this.preActionRoutines);
    }

    private int getPadding() {
        int r1 = this.header.getWord(this.indexPtr);
        int r2 = this.header.getWord(this.indexPtr + 2);
        int sentences = this.header.getByte(r1);
        return r2 - r1 - sentences * 8 - 1;
    }

    private int getRecordLength(int recordPtr) {
        return (this.buffer[recordPtr] & 0xFF) * 8 + this.padding + 1;
    }

    private int getTotalActions() {
        int ptr = this.tablePtr;
        int highest = 0;
        int i = 0;
        while (i < this.indexEntries) {
            int totSentences = this.buffer[ptr++];
            int j = 0;
            while (j < totSentences) {
                int val = this.buffer[ptr + 7] & 0xFF;
                if (val > highest) {
                    highest = val;
                }
                ptr += 8;
                ++j;
            }
            ptr += this.padding;
            ++i;
        }
        return highest + 1;
    }

    public List<Integer> getActionRoutines() {
        ArrayList<Integer> routines = new ArrayList<Integer>();
        routines.addAll(this.actionRoutines);
        routines.addAll(this.preActionRoutines);
        return routines;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getText() {
        void var3_13;
        String line = "----------------------------------------------------------------------------------------------------------------\n";
        StringBuilder text = new StringBuilder(String.valueOf(this.sentenceGroups.size()) + " Grammar tables\n==================\n\n");
        for (SentenceGroup sentenceGroup : this.sentenceGroups) {
            text.append(sentenceGroup + "\n" + line);
        }
        text.append("\n" + this.actionList.size() + " Action groups\n=================\n\n");
        for (List list : this.actionList.values()) {
            for (Sentence sentence : list) {
                text.append(sentence + "\n");
            }
            text.append(line);
        }
        text.append("\n" + this.preActionRoutines.size() + " Pre-action routines\n======================\n\n");
        for (Integer n : this.preActionRoutines) {
            for (Sentence sentence : this.getSentences(n)) {
                text.append(sentence + "\n");
            }
            text.append(line);
        }
        text.append("\n" + this.actionRoutines.size() + " Action routines\n===================\n\n");
        for (Integer n : this.actionRoutines) {
            for (Sentence sentence : this.getSentences(n)) {
                text.append(sentence + "\n");
            }
            text.append(line);
        }
        text.append("\n" + this.totalPrepositions + " Prepositions\n===============\n\n");
        text.append(String.valueOf(HexFormatter.getHexString(this.buffer, this.prepositionPtr, 2)) + "\n");
        boolean bl = false;
        int ptr = this.prepositionPtr + 2;
        while (var3_13 < this.totalPrepositions) {
            text.append(String.valueOf(HexFormatter.getHexString(this.buffer, ptr, 4)) + "   ");
            int id = this.header.getByte(ptr + 3);
            List<String> preps = this.header.dictionary.getPrepositions(id);
            String prepString = this.makeWordBlock(preps);
            text.append(String.valueOf(prepString) + "\n");
            ++var3_13;
            ptr += 4;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private List<Sentence> getSentences(int routine) {
        ArrayList<Sentence> sentences = new ArrayList<Sentence>();
        for (SentenceGroup sg : this.sentenceGroups) {
            for (Sentence s : sg.sentences) {
                if (s.actionRoutine != routine && s.preActionRoutine != routine) continue;
                sentences.add(s);
            }
        }
        return sentences;
    }

    private String makeWordBlock(List<String> words) {
        StringBuilder text = new StringBuilder("[");
        if (words.size() > 0) {
            for (String word : words) {
                text.append(String.valueOf(word) + ", ");
            }
            text.deleteCharAt(text.length() - 1);
            text.deleteCharAt(text.length() - 1);
        } else {
            text.append("** not found **");
        }
        text.append("]");
        return text.toString();
    }

    private class Sentence {
        int startPtr;
        SentenceGroup parent;
        int actionId;
        int actionRoutine;
        int preActionRoutine;
        String sentenceText;

        public Sentence(int ptr, SentenceGroup parent) {
            this.startPtr = ptr;
            this.parent = parent;
            int totObjects = Grammar.this.buffer[ptr++] & 0xFF;
            StringBuilder sentence = new StringBuilder();
            int k = 0;
            while (k < totObjects) {
                int b;
                if ((b = Grammar.this.buffer[ptr++] & 0xFF) > 0) {
                    sentence.append(" " + this.getPrep(b));
                }
                sentence.append(" OBJ");
                ++k;
            }
            this.sentenceText = sentence.toString();
            this.actionId = Grammar.this.buffer[this.startPtr + 7] & 0xFF;
            int targetOffset = this.actionId * 2;
            this.actionRoutine = Grammar.this.header.getWord(Grammar.this.actionPtr + targetOffset) * 2;
            this.preActionRoutine = Grammar.this.header.getWord(Grammar.this.preActionPtr + targetOffset) * 2;
        }

        private String getPrep(int value) {
            int offset = Grammar.this.prepositionPtr + 2 + (Grammar.this.totalPrepositions - (255 - value) - 1) * 4;
            int address = Grammar.this.header.getWord(offset);
            return Grammar.this.header.dictionary.wordAt(address);
        }

        private String getText() {
            return String.valueOf(this.parent.verbString) + " " + this.sentenceText;
        }

        public String toString() {
            StringBuilder text = new StringBuilder(String.format("%3d  %04X  ", this.parent.id, this.startPtr));
            text.append(HexFormatter.getHexString(Grammar.this.buffer, this.startPtr, 8));
            String r1 = this.preActionRoutine == 0 ? "" : String.format("R:%05X", this.preActionRoutine);
            text.append(String.format("  %-7s  R:%05X  %s", r1, this.actionRoutine, this.getText()));
            return text.toString();
        }
    }

    private class SentenceGroup
    implements Iterable<Sentence> {
        int startPtr;
        int id;
        List<Sentence> sentences = new ArrayList<Sentence>();
        String verbString;

        public SentenceGroup(int id, int ptr) {
            this.startPtr = ptr;
            this.id = id;
            int records = Grammar.this.buffer[ptr] & 0xFF;
            this.verbString = Grammar.this.makeWordBlock(Grammar.this.header.dictionary.getVerbs(id));
            int j = 0;
            int offset = this.startPtr + 1;
            while (j < records) {
                this.sentences.add(new Sentence(offset, this));
                ++j;
                offset += 8;
            }
        }

        public String toString() {
            StringBuilder text = new StringBuilder();
            for (Sentence sentence : this.sentences) {
                text.append(sentence + "\n");
            }
            text.deleteCharAt(text.length() - 1);
            return text.toString();
        }

        @Override
        public Iterator<Sentence> iterator() {
            return this.sentences.iterator();
        }
    }
}

