/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;

class Globals
extends AbstractFile {
    static final int TOTAL_GLOBALS = 240;
    Header header;
    int globalsPtr;
    int globalsSize;
    int arrayPtr;
    int arraySize;

    public Globals(Header header) {
        super("Globals", header.buffer);
        this.header = header;
        this.globalsPtr = header.globalsOffset;
        this.globalsSize = 480;
        this.arrayPtr = this.globalsPtr + this.globalsSize;
        this.arraySize = header.staticMemory - this.arrayPtr;
        this.hexBlocks.add(new AbstractFile.HexBlock(this.globalsPtr, this.globalsSize, "Globals:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.arrayPtr, this.arraySize, "Arrays:"));
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int i = 1;
        while (i <= 240) {
            int value = this.header.getWord(this.globalsPtr + i * 2);
            text.append(String.format("G%03d    %04X    ", i, value));
            int address = value * 2;
            if (address >= this.header.stringPointer && address < this.header.fileLength) {
                text.append(String.valueOf(this.header.stringManager.stringAt(address)) + "\n");
            } else {
                text.append(String.format("%,6d%n", value));
            }
            ++i;
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }
}

