/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class Dictionary
extends AbstractFile {
    Map<Integer, ZString> dictionary;
    int totalEntries;
    int totalSeparators;
    int dictionaryPtr;
    int dictionarySize;
    int entryLength;
    Header header;
    Map<Integer, List<WordEntry>> synonymList = new TreeMap<Integer, List<WordEntry>>();

    public Dictionary(Header header) {
        super("Dictionary", header.buffer);
        this.header = header;
        this.dictionaryPtr = header.dictionaryOffset;
        this.dictionary = new TreeMap<Integer, ZString>();
        this.totalSeparators = this.buffer[this.dictionaryPtr] & 0xFF;
        int ptr = this.dictionaryPtr + this.totalSeparators + 1;
        this.entryLength = this.buffer[ptr++] & 0xFF;
        this.totalEntries = header.getWord(ptr);
        ptr += 2;
        int count = 0;
        int i = 0;
        while (i < this.totalEntries) {
            ZString string = new ZString(this.buffer, ptr, header);
            this.dictionary.put(ptr, string);
            WordEntry wordEntry = new WordEntry(string, count++);
            List<WordEntry> wordEntryList = this.synonymList.get(wordEntry.key);
            if (wordEntryList == null) {
                wordEntryList = new ArrayList<WordEntry>();
                this.synonymList.put(wordEntry.key, wordEntryList);
            }
            wordEntryList.add(wordEntry);
            if ((this.buffer[ptr + 4] & 0x10) != 0) {
                int property;
                int b1 = this.buffer[ptr + 5] & 0xFF;
                int n = property = b1 >= 1 && b1 <= 31 ? b1 : this.buffer[ptr + 6] & 0xFF;
                if (header.propertyNames[property] == null || header.propertyNames[property].length() > string.value.length()) {
                    header.propertyNames[property] = string.value;
                }
            }
            ptr += this.entryLength;
            ++i;
        }
        this.dictionarySize = this.totalSeparators + 3 + this.entryLength * this.totalEntries;
        i = 1;
        while (i < header.propertyNames.length) {
            if (header.propertyNames[i] == null) {
                header.propertyNames[i] = String.valueOf(i);
            }
            ++i;
        }
    }

    public boolean containsWordAt(int address) {
        return this.dictionary.containsKey(address);
    }

    public String wordAt(int address) {
        if (this.dictionary.containsKey(address)) {
            return this.dictionary.get((Object)Integer.valueOf((int)address)).value;
        }
        return "dictionary can't find word @ " + address;
    }

    public List<String> getVerbs(int value) {
        ArrayList<String> words = new ArrayList<String>();
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if (b1 == 65 && b2 == value || (b1 == 98 || b1 == 192 || b1 == 68) && b3 == value) {
                words.add(word.value);
            }
            ptr += this.entryLength;
        }
        return words;
    }

    public List<String> getPrepositions(int value) {
        ArrayList<String> words = new ArrayList<String>();
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if ((b1 == 8 || b1 == 24 || b1 == 72) && b2 == value || (b1 == 27 || b1 == 12 || b1 == 42) && b3 == value) {
                words.add(word.value);
            }
            ptr += this.entryLength;
        }
        return words;
    }

    @Override
    public String getHexDump() {
        StringBuilder text = new StringBuilder();
        text.append(HexFormatter.format(this.buffer, this.dictionaryPtr, this.dictionarySize));
        return text.toString();
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder();
        int count = 0;
        int ptr = this.dictionaryPtr + this.totalSeparators + 4;
        for (ZString word : this.dictionary.values()) {
            text.append(String.format("%04X   %3d   %-6s   %s", ptr, count++, word.value, HexFormatter.getHexString(this.buffer, ptr + 4, this.entryLength - 4)));
            int b1 = this.buffer[ptr + 4] & 0xFF;
            int b2 = this.buffer[ptr + 5] & 0xFF;
            int b3 = this.buffer[ptr + 6] & 0xFF;
            if (b1 == 65) {
                text.append(String.format("  %3d%n", b2));
            } else if (b1 == 98 || b1 == 192 || b1 == 68) {
                text.append(String.format("  %3d%n", b3));
            } else {
                text.append("\n");
            }
            ptr += this.entryLength;
        }
        int lastValue = 0;
        for (List<WordEntry> list : this.synonymList.values()) {
            WordEntry wordEntry = list.get(0);
            if (wordEntry.value != lastValue) {
                lastValue = wordEntry.value;
                text.append("\n");
            }
            if (wordEntry.value == 128) {
                for (WordEntry we : list) {
                    text.append(we + "\n");
                }
                text.deleteCharAt(text.length() - 1);
            } else {
                text.append(wordEntry);
            }
            if ((this.buffer[wordEntry.word.startPtr + 4] & 0x10) != 0) {
                text.append("  property");
            }
            text.append("\n");
        }
        text.deleteCharAt(text.length() - 1);
        return text.toString();
    }

    private class WordEntry
    implements Comparable<WordEntry> {
        ZString word;
        int seq;
        int value;
        int key;
        String bits;

        public WordEntry(ZString word, int seq) {
            this.word = word;
            this.seq = seq;
            int b1 = Dictionary.this.buffer[word.startPtr + 4] & 0xFF;
            int b2 = Dictionary.this.buffer[word.startPtr + 5] & 0xFF;
            int b3 = Dictionary.this.buffer[word.startPtr + 6] & 0xFF;
            this.key = b1 << 16 | b2 << 8 | b3;
            this.value = b1;
            this.bits = Integer.toBinaryString(b1);
            if (this.bits.length() < 8) {
                this.bits = String.valueOf("00000000".substring(this.bits.length())) + this.bits;
            }
        }

        @Override
        public int compareTo(WordEntry o) {
            return this.value - o.value;
        }

        public String toString() {
            StringBuilder list = new StringBuilder("[");
            if ((this.key & 0x800000) == 0) {
                for (WordEntry we : Dictionary.this.synonymList.get(this.key)) {
                    list.append(String.valueOf(we.word.value) + ", ");
                }
                list.deleteCharAt(list.length() - 1);
                list.deleteCharAt(list.length() - 1);
            } else {
                list.append(this.word.value);
            }
            list.append("]");
            StringBuilder text = new StringBuilder();
            text.append(String.format("%04X   %3d   %-6s   %s  %s   %s", this.word.startPtr, this.seq, this.word.value, this.bits, HexFormatter.getHexString(Dictionary.this.buffer, this.word.startPtr + 4, Dictionary.this.entryLength - 4), list.toString()));
            return text.toString();
        }
    }
}

