/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.infocom;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.infocom.Header;
import com.bytezone.diskbrowser.infocom.ZString;
import java.util.ArrayList;
import java.util.List;

class Abbreviations
extends AbstractFile {
    List<ZString> list;
    Header header;
    int dataPtr;
    int dataSize;
    int tablePtr;
    int tableSize;

    public Abbreviations(Header header) {
        super("Abbreviations", header.buffer);
        this.header = header;
        this.dataPtr = header.getWord(header.abbreviationsTable) * 2;
        this.dataSize = header.abbreviationsTable - this.dataPtr;
        this.tablePtr = header.abbreviationsTable;
        this.tableSize = header.objectTable - header.abbreviationsTable;
        this.hexBlocks.add(new AbstractFile.HexBlock(this.dataPtr, this.dataSize, "Abbreviations data:"));
        this.hexBlocks.add(new AbstractFile.HexBlock(this.tablePtr, this.tableSize, "Abbreviations table:"));
    }

    private void populate() {
        System.out.println("populating abbreviations");
        this.list = new ArrayList<ZString>();
        int i = this.header.abbreviationsTable;
        while (i < this.header.objectTable) {
            int j = this.header.getWord(i) * 2;
            ZString zs = new ZString(this.buffer, j, this.header);
            this.list.add(zs);
            i += 2;
        }
    }

    public String getAbbreviation(int abbreviationNumber) {
        if (this.list == null) {
            this.populate();
        }
        return this.list.get((int)abbreviationNumber).value;
    }

    @Override
    public String getText() {
        if (this.list == null) {
            this.populate();
        }
        StringBuilder text = new StringBuilder();
        int count = 0;
        for (ZString word : this.list) {
            text.append(String.format("%3d  %s%n", count++, word.value));
        }
        if (this.list.size() > 0) {
            text.deleteCharAt(text.length() - 1);
        }
        return text.toString();
    }
}

