/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

public class TreeBuilder {
    FileComparator fc = new FileComparator();
    JTree tree;
    int totalDisks;

    public TreeBuilder(File folder) {
        assert (folder.exists());
        assert (folder.isDirectory());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(new FileNode(folder));
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.tree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        this.addFiles(root, folder);
        this.setDiskIcon("/com/bytezone/diskbrowser/icons/disk.png");
        ((FileNode)root.getUserObject()).disks = this.totalDisks;
    }

    private void addFiles(DefaultMutableTreeNode node, File directory) {
        File[] files = directory.listFiles();
        Arrays.sort(files, this.fc);
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String filename;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new FileNode(file));
                newNode.setAllowsChildren(true);
                node.add(newNode);
                this.addFiles(newNode, file);
            } else if ((file.length() == 143360L || file.length() >= 200000L) && this.validFileType(filename = file.getAbsolutePath())) {
                DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(new FileNode(file));
                newNode.setAllowsChildren(false);
                node.add(newNode);
                ++this.totalDisks;
            }
            ++n2;
        }
    }

    private boolean validFileType(String filename) {
        int dotPos = filename.lastIndexOf(46);
        String suffix = filename.substring(dotPos + 1);
        return suffix.equalsIgnoreCase("po") || suffix.equalsIgnoreCase("dsk") || suffix.equalsIgnoreCase("do") || suffix.equalsIgnoreCase("hdv");
    }

    private void setDiskIcon(String iconName) {
        URL url = this.getClass().getResource(iconName);
        if (url != null) {
            ImageIcon icon = new ImageIcon(url);
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)this.tree.getCellRenderer();
            renderer.setLeafIcon(icon);
            this.tree.setCellRenderer(renderer);
            this.tree.setRowHeight(18);
        } else {
            System.out.println("Failed to set the disk icon : " + iconName);
        }
    }

    private class FileComparator
    implements Comparator<File> {
        private FileComparator() {
        }

        @Override
        public int compare(File filea, File fileb) {
            if (filea.isDirectory() && !fileb.isDirectory()) {
                return -1;
            }
            if (!filea.isDirectory() && fileb.isDirectory()) {
                return 1;
            }
            return filea.getName().compareToIgnoreCase(fileb.getName());
        }
    }

    public class FileNode {
        public final File file;
        private static final int MAX_NAME_LENGTH = 36;
        private static final int SUFFIX_LENGTH = 12;
        private static final int PREFIX_LENGTH = 21;
        private FormattedDisk formattedDisk;
        private int disks;

        public FileNode(File file) {
            this.file = file;
        }

        public FormattedDisk formattedDisk() {
            if (this.formattedDisk == null) {
                this.formattedDisk = DiskFactory.createDisk(this.file);
            }
            return this.formattedDisk;
        }

        public boolean replaceDisk(FormattedDisk disk) {
            String path = disk.getDisk().getFile().getAbsolutePath();
            if (this.formattedDisk != null && path.equals(this.file.getAbsolutePath())) {
                this.formattedDisk = disk;
                return true;
            }
            return false;
        }

        public String toString() {
            String name = this.file.getName();
            if (name.length() > 36) {
                name = String.valueOf(name.substring(0, 21)) + "..." + name.substring(name.length() - 12);
            }
            if (this.disks > 0) {
                return String.format("%s (%,d)", name, this.disks);
            }
            return name;
        }
    }
}

