/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.DefaultAction;
import com.bytezone.common.Platform;
import com.bytezone.diskbrowser.gui.CatalogPanel;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;

class RootDirectoryAction
extends DefaultAction {
    File rootDirectory;
    CatalogPanel catalogPanel;

    public RootDirectoryAction(File rootDirectory, CatalogPanel catalogPanel) {
        super("Set root folder...", "Defines where the disk images are kept", "/com/bytezone/diskbrowser/icons/");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke("alt S"));
        this.putValue("MnemonicKey", 83);
        this.rootDirectory = rootDirectory;
        this.catalogPanel = catalogPanel;
        this.setIcon("SmallIcon", "folder_explore_16.png");
        this.setIcon("SwingLargeIconKey", "folder_explore_32.png");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int result;
        JFileChooser chooser = new JFileChooser(Platform.userHome);
        chooser.setDialogTitle("Select FOLDER containing disk images");
        chooser.setFileSelectionMode(1);
        if (this.rootDirectory != null) {
            chooser.setSelectedFile(this.rootDirectory);
        }
        if ((result = chooser.showDialog(null, "Accept")) == 0) {
            File file = chooser.getSelectedFile();
            if (!file.isDirectory()) {
                file = file.getParentFile();
            }
            if (file != null) {
                this.rootDirectory = file;
                this.catalogPanel.changeRootPanel(file);
            }
        }
    }
}

