/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import javax.swing.event.EventListenerList;

public class QuitAction
extends AbstractAction {
    EventListenerList listenerList = new EventListenerList();
    Preferences preferences;

    public QuitAction(Preferences prefs) {
        super("Quit");
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.putValue("ShortDescription", "Closes the window and exits the program");
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(81, mask));
        this.putValue("MnemonicKey", 69);
        this.preferences = prefs;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.quit();
    }

    public void quit() {
        this.fireQuitEvent();
    }

    public void addQuitListener(QuitListener listener) {
        this.listenerList.add(QuitListener.class, listener);
    }

    public void removeQuitListener(QuitListener listener) {
        this.listenerList.remove(QuitListener.class, listener);
    }

    public void fireQuitEvent() {
        QuitListener[] listeners;
        QuitListener[] quitListenerArray = listeners = (QuitListener[])this.listenerList.getListeners(QuitListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            QuitListener listener = quitListenerArray[n2];
            listener.quit(this.preferences);
            ++n2;
        }
        System.exit(0);
    }

    public static interface QuitListener
    extends EventListener {
        public void quit(Preferences var1);
    }
}

