/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.Platform;
import com.bytezone.common.SpringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import javax.swing.border.EmptyBorder;

class PreferencesDialog
extends JDialog {
    static final String prefsCatalogFont = "CatalogFont";
    static final String prefsDataFont = "DataFont";
    static final String prefsCatalogFontSize = "CatalogFontSize";
    static final String prefsDataFontSize = "DataFontSize";
    static final String defaultFontName = "Lucida Sans Typewriter";
    static final int defaultFontSize = 12;
    private final JComboBox catalogFontList = new JComboBox<String>(Platform.fontNames);
    private final JComboBox dataFontList = new JComboBox<String>(Platform.fontNames);
    private final String[] sizes = new String[]{"8", "9", "10", "11", "12", "13", "14", "15", "16"};
    private final JComboBox catalogFontSizes = new JComboBox<String>(this.sizes);
    private final JComboBox dataFontSizes = new JComboBox<String>(this.sizes);
    private final Preferences prefs;
    private final JButton apply = new JButton("Apply");
    private String catalogFontName;
    private String dataFontName;
    private int catalogFontSize;
    private int dataFontSize;

    public PreferencesDialog(JFrame owner, Preferences prefs) {
        super(owner, "Set Preferences", false);
        this.prefs = prefs;
        this.catalogFontName = prefs.get(prefsCatalogFont, defaultFontName);
        this.dataFontName = prefs.get(prefsDataFont, defaultFontName);
        this.catalogFontSize = prefs.getInt(prefsCatalogFontSize, 12);
        this.dataFontSize = prefs.getInt(prefsDataFontSize, 12);
        this.catalogFontList.setSelectedItem(this.catalogFontName);
        this.dataFontList.setSelectedItem(this.dataFontName);
        this.catalogFontSizes.setSelectedItem(String.valueOf(this.catalogFontSize));
        this.dataFontSizes.setSelectedItem(String.valueOf(this.dataFontSize));
        this.catalogFontList.setMaximumRowCount(30);
        this.dataFontList.setMaximumRowCount(30);
        this.catalogFontSizes.setMaximumRowCount(this.sizes.length);
        this.dataFontSizes.setMaximumRowCount(this.sizes.length);
        Listener listener = new Listener();
        this.catalogFontList.addActionListener(listener);
        this.dataFontList.addActionListener(listener);
        this.catalogFontSizes.addActionListener(listener);
        this.dataFontSizes.addActionListener(listener);
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.addCancelByEscapeKey();
        JPanel layoutPanel = new JPanel();
        layoutPanel.setBorder(new EmptyBorder(10, 20, 0, 20));
        layoutPanel.setLayout(new SpringLayout());
        layoutPanel.add(new JLabel("Catalog panel font", 11));
        layoutPanel.add(this.catalogFontList);
        layoutPanel.add(this.catalogFontSizes);
        layoutPanel.add(new JLabel("Output panel font", 11));
        layoutPanel.add(this.dataFontList);
        layoutPanel.add(this.dataFontSizes);
        SpringUtilities.makeCompactGrid(layoutPanel, 2, 3, 10, 5, 10, 5);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)layoutPanel, "Center");
        panel.add((Component)this.getCommandPanel(), "South");
        this.getContentPane().add(panel);
        this.pack();
        this.setLocationRelativeTo(owner);
        this.setVisible(true);
    }

    private JComponent getCommandPanel() {
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesDialog.this.closeDialog();
            }
        });
        this.apply.setEnabled(false);
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesDialog.this.updatePreferences();
                PreferencesDialog.this.apply.setEnabled(false);
            }
        });
        JButton ok = new JButton("OK");
        this.getRootPane().setDefaultButton(ok);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                PreferencesDialog.this.updatePreferences();
                PreferencesDialog.this.closeDialog();
            }
        });
        JPanel commandPanel = new JPanel();
        commandPanel.add(cancel);
        commandPanel.add(this.apply);
        commandPanel.add(ok);
        return commandPanel;
    }

    private void updatePreferences() {
        int newFontSize;
        String newFontName = (String)this.catalogFontList.getSelectedItem();
        if (!newFontName.equals(this.catalogFontName)) {
            this.prefs.put(prefsCatalogFont, newFontName);
            this.catalogFontName = newFontName;
        }
        if (!(newFontName = (String)this.dataFontList.getSelectedItem()).equals(this.dataFontName)) {
            this.prefs.put(prefsDataFont, newFontName);
            this.dataFontName = newFontName;
        }
        if ((newFontSize = Integer.parseInt((String)this.catalogFontSizes.getSelectedItem())) != this.catalogFontSize) {
            this.prefs.putInt(prefsCatalogFontSize, newFontSize);
            this.catalogFontSize = newFontSize;
        }
        if ((newFontSize = Integer.parseInt((String)this.dataFontSizes.getSelectedItem())) != this.dataFontSize) {
            this.prefs.putInt(prefsDataFontSize, newFontSize);
            this.dataFontSize = newFontSize;
        }
    }

    private void addCancelByEscapeKey() {
        String CANCEL_ACTION_KEY = "CANCEL_ACTION_KEY";
        int noModifiers = 0;
        KeyStroke escapeKey = KeyStroke.getKeyStroke(27, noModifiers, false);
        InputMap inputMap = this.getRootPane().getInputMap(1);
        inputMap.put(escapeKey, CANCEL_ACTION_KEY);
        AbstractAction cancelAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PreferencesDialog.this.closeDialog();
            }
        };
        this.getRootPane().getActionMap().put(CANCEL_ACTION_KEY, cancelAction);
    }

    private void closeDialog() {
        this.dispose();
    }

    class Listener
    implements ActionListener {
        Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreferencesDialog.this.apply.setEnabled(true);
        }
    }
}

