/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.Platform;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.JPanel;

class DiskLegendPanel
extends JPanel {
    static final int LEFT = 10;
    static final int TOP = 10;
    FormattedDisk disk;
    DiskLayoutPanel.LayoutDetails layoutDetails;
    Font font = Platform.getFont(Platform.FontType.SANS_SERIF, Platform.FontSize.BASE);

    public DiskLegendPanel() {
        this.setBackground(Color.WHITE);
    }

    public void setDisk(FormattedDisk disk, DiskLayoutPanel.LayoutDetails details) {
        this.disk = disk;
        this.layoutDetails = details;
        this.repaint();
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(0, 160);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.disk == null) {
            return;
        }
        g.setFont(this.font);
        int count = 0;
        int lineHeight = 20;
        for (SectorType type : this.disk.getSectorTypeList()) {
            int x = 10 + (count % 2 == 0 ? 0 : 145);
            int y = 10 + count++ / 2 * lineHeight;
            g.setColor(Color.GRAY);
            g.drawRect(x, y, this.layoutDetails.block.width, this.layoutDetails.block.height);
            g.setColor(type.colour);
            g.fillRect(x + 2, y + 2, this.layoutDetails.block.width - 3, this.layoutDetails.block.height - 3);
            g.setColor(Color.BLACK);
            g.drawString(type.name, x + this.layoutDetails.block.width + 4, y + 12);
        }
        int y = ++count / 2 * lineHeight + 20 + 5;
        int val = this.disk.falseNegativeBlocks();
        if (val > 0) {
            g.drawString(String.valueOf(val) + " unused sector" + (val == 1 ? "" : "s") + " marked as unavailable", 10, y);
            y += lineHeight;
        }
        if ((val = this.disk.falsePositiveBlocks()) > 0) {
            g.drawString(String.valueOf(val) + " used sector" + (val == 1 ? "" : "s") + " marked as available", 10, y);
        }
    }
}

