/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class DiskLayoutSelection
implements Iterable<DiskAddress> {
    private final List<DiskAddress> highlights = new ArrayList<DiskAddress>();

    public void doClick(Disk disk, DiskAddress da, boolean extend, boolean append) {
        if (!extend && !append || this.highlights.size() == 0) {
            this.highlights.clear();
            this.highlights.add(da);
            return;
        }
        for (DiskAddress setDA : this.highlights) {
            if (da.compareTo(setDA) != 0) continue;
            this.highlights.remove(setDA);
            return;
        }
        if (append) {
            this.highlights.add(da);
            Collections.sort(this.highlights);
            return;
        }
        if (this.checkContiguous()) {
            this.extendHighlights(disk, da);
        } else {
            this.adjustHighlights(disk, da);
        }
        Collections.sort(this.highlights);
    }

    @Override
    public Iterator<DiskAddress> iterator() {
        return this.highlights.iterator();
    }

    public List<DiskAddress> getHighlights() {
        return new ArrayList<DiskAddress>(this.highlights);
    }

    public void setSelection(List<DiskAddress> list) {
        this.highlights.clear();
        if (list != null) {
            this.highlights.addAll(list);
        }
    }

    private boolean checkContiguous() {
        int range = this.highlights.get(this.highlights.size() - 1).getBlock() - this.highlights.get(0).getBlock() + 1;
        return range == this.highlights.size();
    }

    private void extendHighlights(Disk disk, DiskAddress da) {
        int hi;
        int lo;
        if (this.highlights.get(0).getBlock() > da.getBlock()) {
            lo = da.getBlock();
            hi = this.highlights.get(0).getBlock() - 1;
        } else {
            lo = this.highlights.get(this.highlights.size() - 1).getBlock() + 1;
            hi = da.getBlock();
        }
        int i = lo;
        while (i <= hi) {
            this.highlights.add(disk.getDiskAddress(i));
            ++i;
        }
    }

    private void adjustHighlights(Disk disk, DiskAddress da) {
        if (da.getBlock() < this.highlights.get(0).getBlock() || da.getBlock() > this.highlights.get(this.highlights.size() - 1).getBlock()) {
            this.extendHighlights(disk, da);
            return;
        }
        this.highlights.add(da);
    }
}

