/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.gui.DiskLayoutSelection;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.Scrollable;

class DiskLayoutImage
extends JComponent
implements Scrollable {
    static final Cursor crosshairCursor = new Cursor(1);
    FormattedDisk disk;
    DiskLayoutPanel.LayoutDetails layoutDetails;
    private boolean showFreeSectors;
    DiskLayoutSelection selectionHandler = new DiskLayoutSelection();
    boolean redo;
    int bw = 30;
    int bh = 15;
    int gw = 8;
    int gh = 35;

    public DiskLayoutImage() {
        this.setPreferredSize(new Dimension(241, 526));
        this.addMouseListener(new MyMouseListener());
        this.setBackground(Color.WHITE);
        this.setOpaque(true);
    }

    public void setDisk(FormattedDisk disk, DiskLayoutPanel.LayoutDetails details) {
        this.disk = disk;
        this.layoutDetails = details;
        this.bw = this.layoutDetails.block.width;
        this.bh = this.layoutDetails.block.height;
        this.gw = this.layoutDetails.grid.width;
        this.gh = this.layoutDetails.grid.height;
        this.setPreferredSize(new Dimension(this.gw * this.bw + 1, this.gh * this.bh + 1));
        this.selectionHandler.setSelection(null);
        this.repaint();
    }

    public void setShowFreeSectors(boolean showFree) {
        this.showFreeSectors = showFree;
        this.repaint();
    }

    void setSelection(List<DiskAddress> sectors) {
        this.selectionHandler.setSelection(sectors);
        if (sectors != null && sectors.size() > 0) {
            DiskAddress da = sectors.size() == 1 ? sectors.get(0) : sectors.get(1);
            this.scrollRectToVisible(this.layoutDetails.getLocation(da));
        }
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.setColor(Color.WHITE);
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.disk == null) {
            return;
        }
        Rectangle clipRect = g.getClipBounds();
        Point p1 = new Point(clipRect.x / this.bw * this.bw, clipRect.y / this.bh * this.bh);
        Point p2 = new Point((clipRect.x + clipRect.width - 1) / this.bw * this.bw, (clipRect.y + clipRect.height - 1) / this.bh * this.bh);
        int totalBlocks = 0;
        int maxBlock = this.gw * this.gh;
        Disk d = this.disk.getDisk();
        List<DiskAddress> selectedBlocks = this.selectionHandler.getHighlights();
        int y = p1.y;
        while (y <= p2.y) {
            int x = p1.x;
            while (x <= p2.x) {
                int blockNo = y / this.bh * this.gw + x / this.bw;
                if (blockNo < maxBlock) {
                    DiskAddress da = d.getDiskAddress(blockNo);
                    boolean flag = this.showFreeSectors && this.disk.isSectorFree(da);
                    boolean selected = selectedBlocks.contains(da);
                    this.drawBlock((Graphics2D)g, blockNo, x, y, flag, selected);
                    ++totalBlocks;
                }
                x += this.bw;
            }
            y += this.bh;
        }
    }

    private void drawBlock(Graphics2D g, int blockNo, int x, int y, boolean flagFree, boolean selected) {
        SectorType type = this.disk.getSectorType(blockNo);
        int offset = (this.bw - 4) / 2 + 1;
        g.setColor(Color.GRAY);
        Rectangle rect = new Rectangle(x, y, this.bw, this.bh);
        g.draw(rect);
        if (type.colour != Color.WHITE) {
            g.setColor(type.colour);
            g.fillRect(rect.x + 2, rect.y + 2, rect.width - 3, rect.height - 3);
        }
        if (flagFree) {
            g.setColor(this.getContrastColor(type));
            g.drawOval(rect.x + offset - 2, rect.y + 4, 7, 7);
        }
        if (selected) {
            g.setColor(this.getContrastColor(type));
            g.fillOval(rect.x + offset, rect.y + 6, 3, 3);
        }
    }

    private Color getContrastColor(SectorType type) {
        if (type.colour == Color.WHITE || type.colour == Color.YELLOW || type.colour == Color.PINK || type.colour == Color.CYAN || type.colour == Color.ORANGE) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(241, 526);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? this.bw : this.bh;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? this.bw * 4 : this.bh * 10;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    void redoEvent(RedoHandler.RedoEvent redoEvent) {
        this.redo = true;
        SectorSelectedEvent event = (SectorSelectedEvent)redoEvent.value;
        this.setSelection(event.getSectors());
        this.fireSectorSelectionEvent(event);
        this.redo = false;
    }

    private void fireSectorSelectionEvent() {
        SectorSelectedEvent event = new SectorSelectedEvent(this, this.selectionHandler.getHighlights(), this.disk);
        this.fireSectorSelectionEvent(event);
    }

    private void fireSectorSelectionEvent(SectorSelectedEvent event) {
        SectorSelectionListener[] listeners;
        event.redo = this.redo;
        SectorSelectionListener[] sectorSelectionListenerArray = listeners = (SectorSelectionListener[])this.listenerList.getListeners(SectorSelectionListener.class);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            SectorSelectionListener listener = sectorSelectionListenerArray[n2];
            listener.sectorSelected(event);
            ++n2;
        }
    }

    public void addSectorSelectionListener(SectorSelectionListener listener) {
        this.listenerList.add(SectorSelectionListener.class, listener);
    }

    public void removeSectorSelectionListener(SectorSelectionListener listener) {
        this.listenerList.remove(SectorSelectionListener.class, listener);
    }

    class MyMouseListener
    extends MouseAdapter {
        private Cursor currentCursor;

        MyMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            int x = e.getX() / DiskLayoutImage.this.bw;
            int y = e.getY() / DiskLayoutImage.this.bh;
            int blockNo = y * DiskLayoutImage.this.gw + x;
            DiskAddress da = DiskLayoutImage.this.disk.getDisk().getDiskAddress(blockNo);
            boolean extend = (e.getModifiersEx() & 0x40) > 0;
            boolean append = (e.getModifiersEx() & 0x80) > 0;
            DiskLayoutImage.this.selectionHandler.doClick(DiskLayoutImage.this.disk.getDisk(), da, extend, append);
            DiskLayoutImage.this.fireSectorSelectionEvent();
            DiskLayoutImage.this.repaint();
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.currentCursor = DiskLayoutImage.this.getCursor();
            DiskLayoutImage.this.setCursor(crosshairCursor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            DiskLayoutImage.this.setCursor(this.currentCursor);
        }
    }
}

