/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.common.Platform;
import com.bytezone.common.State;
import com.bytezone.diskbrowser.gui.AboutAction;
import com.bytezone.diskbrowser.gui.CatalogPanel;
import com.bytezone.diskbrowser.gui.DataPanel;
import com.bytezone.diskbrowser.gui.DiskLayoutPanel;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.HideCatalogAction;
import com.bytezone.diskbrowser.gui.HideLayoutAction;
import com.bytezone.diskbrowser.gui.MenuHandler;
import com.bytezone.diskbrowser.gui.PreferencesAction;
import com.bytezone.diskbrowser.gui.PrintAction;
import com.bytezone.diskbrowser.gui.QuitAction;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.RefreshTreeAction;
import com.bytezone.diskbrowser.gui.RootDirectoryAction;
import com.bytezone.diskbrowser.gui.ShowFreeSectorsAction;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class DiskBrowser
extends JFrame
implements DiskSelectionListener {
    private static final String windowTitle = "Apple ][ Disk Browser";

    public DiskBrowser() {
        super(windowTitle);
        Preferences prefs = Preferences.userNodeForPackage(this.getClass());
        State state = new State(prefs);
        JToolBar toolBar = new JToolBar("Toolbar", 0);
        MenuHandler menuHandler = new MenuHandler(prefs);
        this.setJMenuBar(menuHandler.menuBar);
        this.setLayout(new BorderLayout());
        this.add((Component)toolBar, "North");
        RedoHandler redoHandler = new RedoHandler(this.getRootPane(), toolBar);
        toolBar.addSeparator();
        CatalogPanel catalogPanel = new CatalogPanel(menuHandler, redoHandler, prefs);
        JPanel catalogBorderPanel = this.addPanel(catalogPanel, "Catalog", "West");
        DataPanel dataPanel = new DataPanel(menuHandler, prefs);
        this.addPanel(dataPanel, "Output", "Center");
        DiskLayoutPanel diskLayoutPanel = new DiskLayoutPanel();
        JPanel layoutBorderPanel = this.addPanel(diskLayoutPanel, "Disk layout", "East");
        RootDirectoryAction rootDirectoryAction = new RootDirectoryAction(null, catalogPanel);
        RefreshTreeAction refreshTreeAction = new RefreshTreeAction(catalogPanel);
        PreferencesAction preferencesAction = new PreferencesAction(this, prefs);
        PrintAction print = new PrintAction(dataPanel);
        AboutAction aboutAction = new AboutAction();
        HideCatalogAction hideCatalogAction = new HideCatalogAction(this, catalogBorderPanel);
        HideLayoutAction hideLayoutAction = new HideLayoutAction(this, layoutBorderPanel);
        ShowFreeSectorsAction showFreeAction = new ShowFreeSectorsAction(menuHandler, diskLayoutPanel);
        final QuitAction quitAction = new QuitAction(prefs);
        toolBar.add(rootDirectoryAction);
        toolBar.add(refreshTreeAction);
        toolBar.add(preferencesAction);
        toolBar.add(print);
        toolBar.add(aboutAction);
        catalogPanel.addDiskSelectionListener(this);
        catalogPanel.addDiskSelectionListener(dataPanel);
        catalogPanel.addDiskSelectionListener(diskLayoutPanel);
        catalogPanel.addDiskSelectionListener(redoHandler);
        catalogPanel.addDiskSelectionListener(menuHandler);
        catalogPanel.addFileSelectionListener(dataPanel);
        catalogPanel.addFileSelectionListener(diskLayoutPanel);
        catalogPanel.addFileSelectionListener(redoHandler);
        catalogPanel.addFileSelectionListener(menuHandler);
        diskLayoutPanel.addSectorSelectionListener(dataPanel);
        diskLayoutPanel.addSectorSelectionListener(redoHandler);
        diskLayoutPanel.addSectorSelectionListener(catalogPanel);
        redoHandler.addRedoListener(catalogPanel);
        redoHandler.addRedoListener(diskLayoutPanel);
        menuHandler.printItem.setAction(print);
        menuHandler.addHelpMenuAction(preferencesAction, "prefs");
        menuHandler.addHelpMenuAction(aboutAction, "about");
        menuHandler.refreshTreeItem.setAction(refreshTreeAction);
        menuHandler.rootItem.setAction(rootDirectoryAction);
        menuHandler.showCatalogItem.setAction(hideCatalogAction);
        menuHandler.showLayoutItem.setAction(hideLayoutAction);
        menuHandler.showFreeSectorsItem.setAction(showFreeAction);
        menuHandler.setQuitAction(quitAction);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                quitAction.quit();
            }
        });
        quitAction.addQuitListener(menuHandler);
        quitAction.addQuitListener(catalogPanel);
        this.pack();
        this.setLocationRelativeTo(null);
        Dimension screen = Platform.toolkit.getScreenSize();
        if (screen.width <= 1280) {
            this.setExtendedState(2);
        }
        prefs.addPreferenceChangeListener(catalogPanel);
        prefs.addPreferenceChangeListener(dataPanel);
        if (!menuHandler.showLayoutItem.isSelected()) {
            hideLayoutAction.set(false);
        }
        if (!menuHandler.showCatalogItem.isSelected()) {
            hideCatalogAction.set(false);
        }
        catalogPanel.activate();
        this.setVisible(true);
    }

    private JPanel addPanel(JComponent pane, String title, String location) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        panel.setBorder(BorderFactory.createTitledBorder(title));
        panel.add(pane);
        this.add((Component)panel, location);
        return panel;
    }

    @Override
    public void diskSelected(DiskSelectedEvent e) {
        this.setTitle(windowTitle + e.getFormattedDisk() == null ? "" : e.getFormattedDisk().getName());
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                Platform.setLookAndFeel();
                new DiskBrowser();
            }
        });
    }
}

