/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.catalog.DocumentCreatorFactory;
import com.bytezone.diskbrowser.disk.DualDosDisk;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.AppleDiskTab;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.DiskSelectedEvent;
import com.bytezone.diskbrowser.gui.DiskSelectionListener;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.FileSelectionListener;
import com.bytezone.diskbrowser.gui.FileSystemTab;
import com.bytezone.diskbrowser.gui.MenuHandler;
import com.bytezone.diskbrowser.gui.NoDisksFoundException;
import com.bytezone.diskbrowser.gui.QuitAction;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import com.bytezone.diskbrowser.gui.SectorSelectionListener;
import com.bytezone.diskbrowser.gui.Tab;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

class CatalogPanel
extends JTabbedPane
implements RedoHandler.RedoListener,
SectorSelectionListener,
QuitAction.QuitListener,
PreferenceChangeListener {
    private static final String prefsLastDiskUsed = "Last disk used";
    private static final String prefsLastDosUsed = "Last dos used";
    private static final String prefsLastFileUsed = "Last file used";
    private static final String prefsLastSectorsUsed = "Last sectors used";
    private static final String prefsRootDirectory = "Root directory";
    private Font font;
    private FileSystemTab fileTab;
    private final List<AppleDiskTab> diskTabs = new ArrayList<AppleDiskTab>();
    private final DocumentCreatorFactory lister;
    private final DiskAndFileSelector selector = new DiskAndFileSelector();
    private final RedoHandler navMan;

    public CatalogPanel(MenuHandler mh, RedoHandler navMan, Preferences prefs) {
        String catalogFontName = prefs.get("CatalogFont", "Lucida Sans Typewriter");
        int catalogFontSize = prefs.getInt("CatalogFontSize", 12);
        this.font = new Font(catalogFontName, 0, catalogFontSize);
        this.lister = new DocumentCreatorFactory(mh);
        this.navMan = navMan;
        this.selector.addDiskSelectionListener(this.lister.diskLister);
        this.setTabPlacement(3);
        this.setPreferredSize(new Dimension(330, 523));
        this.createTabs(prefs);
        this.addChangeListener(new TabChangeListener());
    }

    private void createTabs(Preferences prefs) {
        String rootDirectory = prefs.get(prefsRootDirectory, "");
        File rootDirectoryFile = new File(rootDirectory);
        if (!rootDirectoryFile.exists() || !rootDirectoryFile.isDirectory()) {
            System.out.println("No root directory");
            return;
        }
        String lastDiskUsed = prefs.get(prefsLastDiskUsed, "");
        int lastDosUsed = prefs.getInt(prefsLastDosUsed, -1);
        String lastFileUsed = prefs.get(prefsLastFileUsed, "");
        String lastSectorsUsed = prefs.get(prefsLastSectorsUsed, "");
        DiskSelectedEvent diskEvent = null;
        if (!lastDiskUsed.isEmpty()) {
            diskEvent = DiskSelectedEvent.create(this, lastDiskUsed);
            FormattedDisk fd = diskEvent.getFormattedDisk();
            if (lastDosUsed >= 0 && fd instanceof DualDosDisk) {
                ((DualDosDisk)fd).setCurrentDiskNo(lastDosUsed);
            }
        } else {
            System.out.println("no disk selected");
        }
        try {
            this.fileTab = new FileSystemTab(rootDirectoryFile, this.selector, this.navMan, this.font, diskEvent);
            this.fileTab.addTreeMouseListener(new MouseListener());
            this.lister.catalogLister.setNode(this.fileTab.getRootNode());
            this.insertTab("Disk Tree", null, this.fileTab, "Display Apple disks", 0);
        }
        catch (NoDisksFoundException e) {
            e.printStackTrace();
        }
        if (diskEvent != null) {
            AppleDiskTab tab = null;
            FormattedDisk fd = diskEvent.getFormattedDisk();
            if (!lastFileUsed.isEmpty()) {
                AppleFileSource afs = fd.getFile(lastFileUsed);
                if (afs != null) {
                    FileSelectedEvent fileEvent = FileSelectedEvent.create(this, afs);
                    tab = new AppleDiskTab(fd, this.selector, this.navMan, this.font, fileEvent);
                } else {
                    tab = new AppleDiskTab(fd, this.selector, this.navMan, this.font, lastFileUsed);
                }
            } else if (!lastSectorsUsed.isEmpty()) {
                SectorSelectedEvent sectorEvent = SectorSelectedEvent.create(this, fd, lastSectorsUsed);
                tab = new AppleDiskTab(fd, this.selector, this.navMan, this.font, sectorEvent);
            } else {
                tab = new AppleDiskTab(fd, this.selector, this.navMan, this.font);
            }
            if (tab != null) {
                this.diskTabs.add(tab);
                this.add((Component)tab, "D" + this.diskTabs.size());
            } else {
                System.out.println("No disk tab created");
            }
        }
    }

    public void activate() {
        if (this.fileTab == null) {
            System.out.println("No file tab");
            return;
        }
        if (this.diskTabs.size() > 0) {
            this.setSelectedIndex(1);
        } else if (this.fileTab != null) {
            this.setSelectedIndex(0);
        }
    }

    public void changeRootPanel(File root) {
        try {
            FileSystemTab newFileTab = new FileSystemTab(root, this.selector, this.navMan, this.font);
            if (this.fileTab != null) {
                this.removeTabAt(0);
            }
            this.fileTab = newFileTab;
            this.fileTab.addTreeMouseListener(new MouseListener());
            this.lister.catalogLister.setNode(this.fileTab.getRootNode());
            this.insertTab("Disk Tree", null, this.fileTab, null, 0);
            this.setSelectedIndex(0);
        }
        catch (NoDisksFoundException e) {
            JOptionPane.showMessageDialog(null, "Folder " + root.getAbsolutePath() + " has no valid disk images.", "Bad folder", 0);
        }
    }

    public void addDiskPanel(FormattedDisk disk, String lastFileUsed, boolean activate) {
        AppleDiskTab tab2;
        int tabNo = 1;
        for (AppleDiskTab tab2 : this.diskTabs) {
            if (tab2.contains(disk)) {
                this.setSelectedIndex(tabNo);
                return;
            }
            ++tabNo;
        }
        tab2 = new AppleDiskTab(disk, this.selector, this.navMan, this.font);
        this.diskTabs.add(tab2);
        this.add((Component)tab2, "D" + this.diskTabs.size());
        if (activate) {
            this.setSelectedIndex(this.diskTabs.size());
        }
    }

    public void refreshTree() {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        tab.refresh();
        if (tab instanceof AppleDiskTab) {
            this.fileTab.replaceDisk(((AppleDiskTab)tab).disk);
        }
    }

    @Override
    public void quit(Preferences prefs) {
        if (this.fileTab == null) {
            prefs.put(prefsRootDirectory, "");
            prefs.put(prefsLastDiskUsed, "");
            prefs.putInt(prefsLastDosUsed, -1);
            prefs.put(prefsLastFileUsed, "");
            prefs.put(prefsLastSectorsUsed, "");
        } else {
            prefs.put(prefsRootDirectory, this.fileTab.rootFolder.getAbsolutePath());
            if (this.diskTabs.size() == 0) {
                RedoHandler.RedoEvent redoEvent = this.fileTab.redoData.getCurrentEvent();
                if (redoEvent != null) {
                    DiskSelectedEvent event = (DiskSelectedEvent)redoEvent.value;
                    prefs.put(prefsLastDiskUsed, event.getFormattedDisk().getAbsolutePath());
                }
                prefs.put(prefsLastFileUsed, "");
                prefs.put(prefsLastSectorsUsed, "");
            } else {
                AbstractTab selectedTab = (AbstractTab)this.getSelectedComponent();
                if (selectedTab instanceof FileSystemTab) {
                    selectedTab = this.diskTabs.get(this.diskTabs.size() - 1);
                }
                FormattedDisk fd = ((AppleDiskTab)selectedTab).disk;
                prefs.put(prefsLastDiskUsed, fd.getAbsolutePath());
                if (fd instanceof DualDosDisk) {
                    prefs.putInt(prefsLastDosUsed, ((DualDosDisk)fd).getCurrentDiskNo());
                } else {
                    prefs.putInt(prefsLastDosUsed, -1);
                }
                EventObject event = selectedTab.redoData.getCurrentEvent().value;
                if (event instanceof FileSelectedEvent) {
                    AppleFileSource afs = ((FileSelectedEvent)event).file;
                    prefs.put(prefsLastFileUsed, afs == null ? "" : afs.getUniqueName());
                    prefs.put(prefsLastSectorsUsed, "");
                } else if (event instanceof SectorSelectedEvent) {
                    prefs.put(prefsLastFileUsed, "");
                    prefs.put(prefsLastSectorsUsed, ((SectorSelectedEvent)event).toText());
                }
            }
        }
    }

    public void addDiskSelectionListener(DiskSelectionListener listener) {
        this.selector.addDiskSelectionListener(listener);
    }

    public void addFileSelectionListener(FileSelectionListener listener) {
        this.selector.addFileSelectionListener(listener);
    }

    @Override
    public void redo(RedoHandler.RedoEvent event) {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        this.selector.redo = true;
        if (event.type.equals("DiskEvent")) {
            if (tab instanceof FileSystemTab) {
                ((FileSystemTab)tab).redoEvent(event);
            }
        } else if (event.type.equals("FileEvent") && tab instanceof AppleDiskTab) {
            ((AppleDiskTab)tab).redoEvent(event);
        }
        this.selector.redo = false;
    }

    @Override
    public void sectorSelected(SectorSelectedEvent event) {
        Tab tab = (Tab)((Object)this.getSelectedComponent());
        if (tab instanceof AppleDiskTab) {
            ((AppleDiskTab)tab).tree.setSelectionPath(null);
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("CatalogFont")) {
            this.font = new Font(evt.getNewValue(), 0, this.font.getSize());
        }
        if (evt.getKey().equals("CatalogFontSize")) {
            this.font = new Font(this.font.getFontName(), 0, Integer.parseInt(evt.getNewValue()));
        }
        if (this.fileTab != null) {
            this.fileTab.setTreeFont(this.font);
        }
        for (AppleDiskTab tab : this.diskTabs) {
            tab.setTreeFont(this.font);
        }
    }

    private class MouseListener
    extends MouseAdapter {
        private MouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            JTree tree = (JTree)e.getSource();
            int selRow = tree.getRowForLocation(e.getX(), e.getY());
            if (selRow < 0) {
                return;
            }
            TreePath tp = tree.getPathForLocation(e.getX(), e.getY());
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)tp.getLastPathComponent();
            TreeBuilder.FileNode node = (TreeBuilder.FileNode)selectedNode.getUserObject();
            if (node.file.isDirectory()) {
                ((CatalogPanel)CatalogPanel.this).lister.catalogLister.setNode(selectedNode);
            } else if (e.getClickCount() == 2) {
                CatalogPanel.this.addDiskPanel(node.formattedDisk(), null, true);
            }
        }
    }

    private class TabChangeListener
    implements ChangeListener {
        private TabChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            Tab tab = (Tab)((Object)CatalogPanel.this.getSelectedComponent());
            if (tab != null) {
                tab.activate();
            }
        }
    }
}

