/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.disk.DiskFactory;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.gui.AbstractTab;
import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.FileSelectedEvent;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.SectorSelectedEvent;
import java.awt.Font;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

class AppleDiskTab
extends AbstractTab {
    FormattedDisk disk;

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler navMan, Font font, FileSelectedEvent event) {
        super(navMan, selector, font);
        this.create(disk);
        navMan.fileSelected(event);
        System.out.println("restoring a previous disk with a file selected");
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler navMan, Font font, SectorSelectedEvent event) {
        super(navMan, selector, font);
        this.create(disk);
        navMan.sectorSelected(event);
        System.out.println("restoring a previous disk with a sector selected");
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler navMan, Font font, String lastFileUsed) {
        super(navMan, selector, font);
        this.create(disk);
        System.out.println("ooh - couldn't find the previous file");
        DefaultMutableTreeNode node = this.findNode(lastFileUsed);
        if (node != null) {
            AppleFileSource afs = (AppleFileSource)node.getUserObject();
            FileSelectedEvent event = new FileSelectedEvent(this, afs);
            navMan.fileSelected(event);
        }
    }

    public AppleDiskTab(FormattedDisk disk, DiskAndFileSelector selector, RedoHandler navMan, Font font) {
        super(navMan, selector, font);
        this.create(disk);
        System.out.println("User double-clicked a disk");
        AppleFileSource afs = (AppleFileSource)this.findNode(2).getUserObject();
        if (afs == null) {
            afs = (AppleFileSource)this.findNode(1).getUserObject();
        }
        navMan.fileSelected(new FileSelectedEvent(this, afs));
    }

    private void create(FormattedDisk disk) {
        this.disk = disk;
        this.setTree(disk.getCatalogTree());
        this.setSelectionListener(this.tree);
    }

    @Override
    public void activate() {
        this.eventHandler.redo = true;
        this.eventHandler.fireDiskSelectionEvent(this.disk);
        this.eventHandler.redo = false;
        this.tree.setSelectionPath(null);
        this.navMan.setCurrentData(this.redoData);
    }

    @Override
    public void refresh() {
        Object o = this.getSelectedObject();
        String currentFile = o == null ? null : ((AppleFileSource)o).getUniqueName();
        this.disk = DiskFactory.createDisk(this.disk.getAbsolutePath());
        this.setTree(this.disk.getCatalogTree());
        this.selectNode(currentFile);
        this.setSelectionListener(this.tree);
    }

    private void selectNode(String nodeName) {
        DefaultMutableTreeNode selectNode = null;
        if (nodeName != null) {
            selectNode = this.findNode(nodeName);
        }
        if (selectNode == null) {
            selectNode = this.findNode(2);
        }
        if (selectNode != null) {
            this.showNode(selectNode);
        } else {
            System.out.println("First node not found");
        }
    }

    void redoEvent(RedoHandler.RedoEvent event) {
        this.selectNode(((FileSelectedEvent)event.value).file.getUniqueName());
    }

    private DefaultMutableTreeNode findNode(String nodeName) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        while (children.hasMoreElements()) {
            AppleFileSource afs;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children.nextElement();
            Object o = node.getUserObject();
            if (!(o instanceof AppleFileSource) || !nodeName.equals((afs = (AppleFileSource)node.getUserObject()).getUniqueName())) continue;
            return node;
        }
        return null;
    }

    public boolean contains(FormattedDisk disk) {
        return this.disk.getAbsolutePath().equals(disk.getAbsolutePath());
    }

    private void setSelectionListener(JTree tree) {
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                AppleFileSource afs = (AppleFileSource)AppleDiskTab.this.getSelectedObject();
                if (afs != null) {
                    AppleDiskTab.this.eventHandler.fireFileSelectionEvent(afs);
                }
            }
        });
    }
}

