/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.gui;

import com.bytezone.diskbrowser.gui.DiskAndFileSelector;
import com.bytezone.diskbrowser.gui.RedoHandler;
import com.bytezone.diskbrowser.gui.Tab;
import com.bytezone.diskbrowser.gui.TreeBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

abstract class AbstractTab
extends JPanel
implements Tab {
    private static final Cursor handCursor = new Cursor(12);
    private final List<MouseAdapter> adapters = new ArrayList<MouseAdapter>();
    private Font font;
    private final JScrollPane scrollpane;
    final DiskAndFileSelector eventHandler;
    final RedoHandler navMan;
    final RedoHandler.RedoData redoData;
    protected JTree tree;

    public AbstractTab(RedoHandler navMan, DiskAndFileSelector selector, Font font) {
        super(new BorderLayout());
        this.eventHandler = selector;
        this.font = font;
        this.navMan = navMan;
        this.redoData = navMan.createData();
        this.scrollpane = new JScrollPane(null, 22, 31);
        this.scrollpane.setBorder(null);
        this.add((Component)this.scrollpane, "Center");
    }

    protected void setTree(JTree tree) {
        this.tree = tree;
        tree.setFont(this.font);
        this.scrollpane.setViewportView(tree);
        TreeSelectionModel tsm = tree.getSelectionModel();
        tsm.setSelectionMode(1);
        if (this.adapters.size() > 0) {
            this.restoreAdapters();
        } else {
            this.addTreeMouseListener(new CursorHandler());
        }
    }

    protected void setTreeFont(Font font) {
        this.tree.setFont(font);
        this.font = font;
    }

    public void addTreeMouseListener(MouseAdapter adapter) {
        this.tree.addMouseListener(adapter);
        this.adapters.add(adapter);
    }

    private void restoreAdapters() {
        for (MouseAdapter ma : this.adapters) {
            this.tree.addMouseListener(ma);
        }
    }

    protected Object getSelectedObject() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        return node == null ? null : node.getUserObject();
    }

    @Override
    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
    }

    protected DefaultMutableTreeNode findNode(int nodeNo) {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.breadthFirstEnumeration();
        int count = 0;
        DefaultMutableTreeNode selectNode = null;
        while (children.hasMoreElements() && ++count <= nodeNo) {
            selectNode = (DefaultMutableTreeNode)children.nextElement();
        }
        return selectNode;
    }

    protected DefaultMutableTreeNode findFirstLeafNode() {
        DefaultMutableTreeNode rootNode = this.getRootNode();
        Enumeration<TreeNode> children = rootNode.depthFirstEnumeration();
        DefaultMutableTreeNode selectNode = null;
        while (children.hasMoreElements()) {
            selectNode = (DefaultMutableTreeNode)children.nextElement();
            if (!selectNode.isLeaf()) continue;
            TreeBuilder.FileNode node = (TreeBuilder.FileNode)selectNode.getUserObject();
            if (!node.file.isFile()) continue;
            return selectNode;
        }
        return null;
    }

    protected void showNode(DefaultMutableTreeNode showNode) {
        TreePath tp = this.getPathToNode(showNode);
        this.tree.setSelectionPath(tp);
        if (!this.tree.isVisible(tp)) {
            this.tree.scrollPathToVisible(tp);
        }
    }

    protected TreePath getPathToNode(DefaultMutableTreeNode selectNode) {
        DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
        Object[] nodes = treeModel.getPathToRoot(selectNode);
        return new TreePath(nodes);
    }

    private class CursorHandler
    extends MouseAdapter {
        private Cursor oldCursor;

        private CursorHandler() {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            this.oldCursor = AbstractTab.this.getCursor();
            AbstractTab.this.setCursor(handCursor);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            AbstractTab.this.setCursor(this.oldCursor);
        }
    }
}

