/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import java.util.List;

public class SectorList
extends AbstractFile {
    List<DiskAddress> sectors;
    FormattedDisk formattedDisk;

    public SectorList(FormattedDisk formattedDisk, List<DiskAddress> sectors) {
        super("noname", null);
        this.sectors = sectors;
        this.formattedDisk = formattedDisk;
        Disk disk = formattedDisk.getDisk();
        int ptr = 0;
        this.buffer = new byte[sectors.size() * disk.getBlockSize()];
        for (DiskAddress da : sectors) {
            byte[] tempBuffer = disk.readSector(da);
            System.arraycopy(tempBuffer, 0, this.buffer, ptr, disk.getBlockSize());
            ptr += disk.getBlockSize();
        }
    }

    @Override
    public String getText() {
        StringBuilder text = new StringBuilder("Block  Sector Type         Owner\n");
        text.append("-----  ------------------  ---------------------------------------------\n");
        for (DiskAddress da : this.sectors) {
            SectorType sectorType = this.formattedDisk.getSectorType(da);
            String owner = this.formattedDisk.getSectorFilename(da);
            if (owner == null) {
                owner = "";
            }
            text.append(String.format(" %04X  %-18s  %s%n", da.getBlock(), sectorType.name, owner));
        }
        return text.toString();
    }
}

