/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.HexFormatter;
import com.bytezone.diskbrowser.applefile.AssemblerProgram;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.image.BufferedImage;

public abstract class AbstractSector
implements DataSource {
    static String newLine = String.format("%n", new Object[0]);
    static String newLine2 = String.valueOf(newLine) + newLine;
    public byte[] buffer;
    AssemblerProgram assembler;
    String description;

    public AbstractSector(byte[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public String getAssembler() {
        if (this.assembler == null) {
            this.assembler = new AssemblerProgram("noname", this.buffer, 0);
        }
        return this.assembler.getText();
    }

    @Override
    public String getHexDump() {
        return HexFormatter.format(this.buffer, 0, this.buffer.length);
    }

    @Override
    public BufferedImage getImage() {
        return null;
    }

    @Override
    public String getText() {
        if (this.description == null) {
            this.description = this.createText();
        }
        return this.description;
    }

    public abstract String createText();

    protected StringBuilder getHeader(String title) {
        StringBuilder text = new StringBuilder();
        text.append(String.valueOf(title) + newLine2);
        text.append("Offset    Value         Description" + newLine);
        text.append("=======   ===========   =========================================================" + newLine);
        return text;
    }

    protected void addText(StringBuilder text, byte[] b, int offset, int size, String desc) {
        switch (size) {
            case 1: {
                text.append(String.format("%03X       %02X            %s%n", offset, b[offset], desc));
                break;
            }
            case 2: {
                text.append(String.format("%03X-%03X   %02X %02X         %s%n", offset, offset + 1, b[offset], b[offset + 1], desc));
                break;
            }
            case 3: {
                text.append(String.format("%03X-%03X   %02X %02X %02X      %s%n", offset, offset + 2, b[offset], b[offset + 1], b[offset + 2], desc));
                break;
            }
            case 4: {
                text.append(String.format("%03X-%03X   %02X %02X %02X %02X   %s%n", offset, offset + 3, b[offset], b[offset + 1], b[offset + 2], b[offset + 3], desc));
                break;
            }
            default: {
                System.out.println("Invalid length : " + size);
            }
        }
    }

    protected void addTextAndDecimal(StringBuilder text, byte[] b, int offset, int size, String desc) {
        if (size == 1) {
            desc = String.valueOf(desc) + " (" + (b[offset] & 0xFF) + ")";
        } else if (size == 2) {
            desc = String.valueOf(desc) + " (" + ((b[offset + 1] & 0xFF) * 256 + (b[offset] & 0xFF)) + ")";
        } else if (size == 3) {
            desc = String.valueOf(desc) + String.format(" (%,d)", (b[offset + 2] & 0xFF) * 65536 + (b[offset + 1] & 0xFF) * 256 + (b[offset] & 0xFF));
        }
        this.addText(text, b, offset, size, desc);
    }
}

