/*
 * Decompiled with CFR 0.152.
 */
package com.bytezone.diskbrowser.disk;

import com.bytezone.diskbrowser.applefile.AbstractFile;
import com.bytezone.diskbrowser.applefile.AppleFileSource;
import com.bytezone.diskbrowser.applefile.BootSector;
import com.bytezone.diskbrowser.disk.DefaultAppleFileSource;
import com.bytezone.diskbrowser.disk.DefaultSector;
import com.bytezone.diskbrowser.disk.Disk;
import com.bytezone.diskbrowser.disk.DiskAddress;
import com.bytezone.diskbrowser.disk.FormattedDisk;
import com.bytezone.diskbrowser.disk.SectorType;
import com.bytezone.diskbrowser.gui.DataSource;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class AbstractFormattedDisk
implements FormattedDisk {
    protected Disk disk;
    protected ActionListener actionListenerList;
    protected JTree catalogTree;
    protected List<SectorType> sectorTypesList = new ArrayList<SectorType>();
    protected List<AppleFileSource> fileEntries = new ArrayList<AppleFileSource>();
    protected SectorType[] sectorType;
    protected BootSector bootSector;
    public final SectorType emptySector = new SectorType("Unused (empty)", Color.white);
    public final SectorType usedSector = new SectorType("Unused (data)", Color.yellow);
    public final SectorType dosSector = new SectorType("DOS", Color.lightGray);
    protected int falsePositives;
    protected int falseNegatives;
    protected Dimension gridLayout;
    FormattedDisk parent;
    protected BitSet freeBlocks;
    protected BitSet usedBlocks;

    public AbstractFormattedDisk(Disk disk) {
        this.disk = disk;
        this.freeBlocks = new BitSet(disk.getTotalBlocks());
        this.usedBlocks = new BitSet(disk.getTotalBlocks());
        this.sectorTypesList.add(this.emptySector);
        this.sectorTypesList.add(this.usedSector);
        this.setSectorTypes();
        DefaultAppleFileSource afs = new DefaultAppleFileSource(disk.getFile().getName(), disk.toString(), (FormattedDisk)this);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(afs);
        DefaultTreeModel treeModel = new DefaultTreeModel(root);
        this.catalogTree = new JTree(treeModel);
        treeModel.setAsksAllowsChildren(true);
        disk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractFormattedDisk.this.setSectorTypes();
            }
        });
    }

    private void setSectorTypes() {
        this.sectorType = new SectorType[this.disk.getTotalBlocks()];
        int totalBlocks = this.disk.getTotalBlocks();
        for (DiskAddress da : this.disk) {
            SectorType sectorType = this.sectorType[da.getBlock()] = this.disk.isSectorEmpty(da) ? this.emptySector : this.usedSector;
        }
        switch (totalBlocks) {
            case 280: {
                this.gridLayout = new Dimension(8, 35);
                break;
            }
            case 560: {
                this.gridLayout = new Dimension(16, 35);
                break;
            }
            default: {
                int[] sizes;
                int[] nArray = sizes = new int[]{32, 20, 16, 8};
                int n = sizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int size = nArray[n2];
                    if (totalBlocks % size == 0) {
                        this.gridLayout = new Dimension(size, totalBlocks / size);
                        break;
                    }
                    ++n2;
                }
                if (this.gridLayout != null) break;
                System.out.println("Unusable total blocks : " + totalBlocks);
            }
        }
    }

    @Override
    public Disk getDisk() {
        return this.disk;
    }

    @Override
    public FormattedDisk getParent() {
        return this.parent;
    }

    @Override
    public void setParent(FormattedDisk disk) {
        this.parent = disk;
    }

    @Override
    public String getAbsolutePath() {
        return this.disk.getFile().getAbsolutePath();
    }

    @Override
    public String getName() {
        return this.disk.getFile().getName();
    }

    @Override
    public void writeFile(AbstractFile file) {
        System.out.println("not implemented yet");
    }

    @Override
    public List<AppleFileSource> getCatalogList() {
        return this.fileEntries;
    }

    @Override
    public AppleFileSource getFile(String uniqueName) {
        for (AppleFileSource afs : this.fileEntries) {
            if (!afs.getUniqueName().equals(uniqueName)) continue;
            return afs;
        }
        return null;
    }

    @Override
    public JTree getCatalogTree() {
        return this.catalogTree;
    }

    public DefaultMutableTreeNode getCatalogTreeRoot() {
        return (DefaultMutableTreeNode)this.catalogTree.getModel().getRoot();
    }

    public void makeNodeVisible(DefaultMutableTreeNode node) {
        this.catalogTree.makeVisible(new TreePath(((DefaultTreeModel)this.catalogTree.getModel()).getPathToRoot(node)));
    }

    protected DefaultMutableTreeNode findNode(DefaultMutableTreeNode node, String name) {
        Enumeration<TreeNode> children = node.breadthFirstEnumeration();
        if (children != null) {
            while (children.hasMoreElements()) {
                DefaultMutableTreeNode childNode = (DefaultMutableTreeNode)children.nextElement();
                if (childNode.getUserObject().toString().indexOf(name) <= 0) continue;
                return childNode;
            }
        }
        System.out.println("Node not found : " + name);
        return null;
    }

    @Override
    public SectorType getSectorType(int block) {
        return this.getSectorType(this.disk.getDiskAddress(block));
    }

    @Override
    public SectorType getSectorType(int track, int sector) {
        return this.getSectorType(this.disk.getDiskAddress(track, sector));
    }

    @Override
    public SectorType getSectorType(DiskAddress da) {
        return this.sectorType[da.getBlock()];
    }

    @Override
    public List<SectorType> getSectorTypeList() {
        return this.sectorTypesList;
    }

    @Override
    public void setSectorType(int block, SectorType type) {
        this.sectorType[block] = type;
    }

    @Override
    public DataSource getFormattedSector(DiskAddress da) {
        byte[] buffer = this.disk.readSector(da);
        return new DefaultSector("Data sector", buffer);
    }

    @Override
    public AppleFileSource getCatalog() {
        return new DefaultAppleFileSource(this.disk.toString(), this);
    }

    @Override
    public String getSectorFilename(DiskAddress da) {
        return "unknown";
    }

    @Override
    public int clearOrphans() {
        System.out.println("Not implemented yet");
        return 0;
    }

    @Override
    public boolean isSectorFree(DiskAddress da) {
        return this.freeBlocks.get(da.getBlock());
    }

    @Override
    public boolean isSectorFree(int blockNo) {
        return this.freeBlocks.get(blockNo);
    }

    @Override
    public void setSectorFree(int block, boolean free) {
        this.freeBlocks.set(block, free);
    }

    @Override
    public boolean stillAvailable(DiskAddress da) {
        return this.sectorType[da.getBlock()] == this.usedSector || this.sectorType[da.getBlock()] == this.emptySector;
    }

    @Override
    public boolean stillAvailable(int blockNo) {
        return this.sectorType[blockNo] == this.usedSector || this.sectorType[blockNo] == this.emptySector;
    }

    @Override
    public void verify() {
        System.out.println("Sectors to clean :");
        int i = 0;
        int max = this.disk.getTotalBlocks();
        while (i < max) {
            if (this.freeBlocks.get(i)) {
                if (this.sectorType[i] == this.usedSector) {
                    System.out.printf("%04X clean%n", i);
                }
            } else if (this.sectorType[i] == this.usedSector) {
                System.out.printf("%04X *** error ***%n", i);
            }
            ++i;
        }
    }

    @Override
    public Dimension getGridLayout() {
        return this.gridLayout;
    }

    @Override
    public int falsePositiveBlocks() {
        return this.falsePositives;
    }

    @Override
    public int falseNegativeBlocks() {
        return this.falseNegatives;
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.add(this.actionListenerList, actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListenerList = AWTEventMulticaster.remove(this.actionListenerList, actionListener);
    }

    public void notifyListeners(String text) {
        if (this.actionListenerList != null) {
            this.actionListenerList.actionPerformed(new ActionEvent(this, 1001, text));
        }
    }
}

